/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.j3d.terrain.AbstractTerrainData;
import org.j3d.terrain.FreeFormTerrainData;
import org.j3d.terrain.TextureTileGenerator;

public abstract class AbstractFreeFormTerrainData
extends AbstractTerrainData
implements FreeFormTerrainData {
    protected TextureTileGenerator tileGenerator;
    protected int gridWidth;
    protected int gridDepth;
    private int widthPixelsPerGridStep;
    private int depthPixelsPerGridStep;
    private Rectangle pixelBounds;

    protected AbstractFreeFormTerrainData() {
        super(3);
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridDepth() {
        return this.gridDepth;
    }

    @Override
    public BufferedImage getTexture(Rectangle bounds) {
        this.pixelBounds.x = bounds.x * this.widthPixelsPerGridStep;
        this.pixelBounds.y = bounds.y * this.depthPixelsPerGridStep;
        this.pixelBounds.width = bounds.width * this.widthPixelsPerGridStep;
        this.pixelBounds.height = bounds.height * this.depthPixelsPerGridStep;
        BufferedImage ret_val = null;
        if (this.tileGenerator != null) {
            ret_val = this.tileGenerator.getTextureTile(this.pixelBounds);
        }
        return ret_val;
    }

    public void setTextureTileGenerator(TextureTileGenerator gen) {
        this.tileGenerator = gen;
        if (gen != null) {
            if (this.pixelBounds != null) {
                this.pixelBounds = new Rectangle();
            }
            Dimension tex_size = gen.getTextureSize();
            this.widthPixelsPerGridStep = tex_size.width / this.gridWidth;
            this.depthPixelsPerGridStep = tex_size.height / this.gridDepth;
        }
    }
}

