/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import org.j3d.geom.terrain.HeightMapGeometry;
import org.j3d.maths.vector.Point3d;
import org.j3d.maths.vector.Vector3d;
import org.j3d.terrain.TerrainData;
import org.j3d.util.I18nManager;
import org.j3d.util.frustum.ViewFrustum;

public abstract class Landscape
implements HeightMapGeometry {
    private static final String NULL_VIEW_FRUSTUM_MSG_PROP = "org.j3d.terrain.Landscape.nullViewFrustumMsg";
    private static final String NULL_TERRAIN_MSG_PROP = "org.j3d.terrain.Landscape.nullTerrainDataMsg";
    protected ViewFrustum landscapeView;
    protected TerrainData terrainData;

    public Landscape(ViewFrustum view, TerrainData data) {
        if (view == null) {
            I18nManager intl_mgr = I18nManager.getManager();
            String msg = intl_mgr.getString(NULL_VIEW_FRUSTUM_MSG_PROP);
            throw new IllegalArgumentException(msg);
        }
        if (data == null) {
            I18nManager intl_mgr = I18nManager.getManager();
            String msg = intl_mgr.getString(NULL_TERRAIN_MSG_PROP);
            throw new IllegalArgumentException(msg);
        }
        this.terrainData = data;
        this.landscapeView = view;
    }

    public float getHeight(float x, float z) {
        return this.terrainData.getHeight(x, z);
    }

    public abstract void initialize(Point3d var1, Vector3d var2);

    public abstract void setView(Point3d var1, Vector3d var2);
}

