/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import org.j3d.terrain.roam.QueueItem;

class FastQueue {
    private static final int BUCKETS = 2048;
    private static final float TOP = 0.2f;
    private boolean diamondQueue = false;
    private QueueItem[] queueBuckets;
    private int largest = 0;
    private int smallest = 2048;
    private int currentBucket;

    public FastQueue(boolean diamondQueue) {
        this.diamondQueue = diamondQueue;
        this.queueBuckets = new QueueItem[2049];
    }

    public void add(QueueItem node) {
        QueueItem existingNode;
        node.next = existingNode = this.getList(node);
        if (existingNode != null) {
            existingNode.prev = node;
        }
        node.prev = null;
        this.queueBuckets[this.currentBucket] = node;
        this.largest = Math.max(this.largest, this.currentBucket);
        this.smallest = Math.min(this.smallest, this.currentBucket);
    }

    public void remove(QueueItem node) {
        if (node.prev == null) {
            QueueItem existingNode = this.getList(node);
            if (existingNode == null || existingNode != node) {
                return;
            }
            this.queueBuckets[this.currentBucket] = node.next;
            if (node.next != null) {
                node.next.prev = null;
            }
            node.prev = null;
            node.next = null;
        } else {
            node.prev.next = node.next;
            if (node.next != null) {
                node.next.prev = node.prev;
            }
            node.prev = null;
            node.next = null;
        }
    }

    public QueueItem last() {
        QueueItem list = this.queueBuckets[this.largest];
        while (list == null && this.largest >= this.smallest) {
            --this.largest;
            list = this.queueBuckets[this.largest];
        }
        return list;
    }

    public QueueItem first() {
        QueueItem list = this.queueBuckets[this.smallest];
        while (list == null && this.smallest <= this.largest) {
            ++this.smallest;
            list = this.queueBuckets[this.smallest];
        }
        return list;
    }

    public void clear() {
        for (int i = 0; i < this.queueBuckets.length; ++i) {
            this.queueBuckets[i] = null;
        }
    }

    private QueueItem getList(QueueItem node) {
        float value = node.variance;
        this.currentBucket = value > 0.2f ? 2048 : (int)(value / 0.2f * 2048.0f);
        return this.queueBuckets[this.currentBucket];
    }
}

