/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Rectangle;
import org.j3d.terrain.roam.ROAMPatch;

class PatchGrid {
    private int numNorth;
    private int numEast;
    private int northOffset;
    private int eastOffset;
    private ROAMPatch[][] grid;

    PatchGrid(Rectangle bounds) {
        this.grid = new ROAMPatch[bounds.width][bounds.height];
        this.numEast = bounds.width;
        this.numNorth = bounds.height;
        this.eastOffset = bounds.x;
        this.northOffset = bounds.y;
    }

    void prepareNewBounds(Rectangle bounds) {
        int num_copy;
        int j;
        int i;
        ROAMPatch[][] tmp;
        if (bounds.width > this.grid.length) {
            tmp = new ROAMPatch[bounds.width][];
            for (i = 0; i < this.grid.length; ++i) {
                tmp[i] = this.grid[i];
            }
            int cur_depth = this.grid[0].length;
            while (i < bounds.width) {
                tmp[i] = new ROAMPatch[cur_depth];
                ++i;
            }
        } else if (bounds.width < this.numEast) {
            for (i = bounds.width; i < this.numEast; ++i) {
                for (j = 0; j < this.numNorth; ++j) {
                    this.grid[i][j] = null;
                }
            }
        }
        if (bounds.height > this.grid[0].length) {
            for (i = 0; i < this.numEast; ++i) {
                tmp = new ROAMPatch[bounds.height];
                System.arraycopy(this.grid[i], 0, tmp, 0, this.numNorth);
                this.grid[i] = tmp;
            }
            while (i < this.grid.length) {
                this.grid[i] = new ROAMPatch[bounds.height];
                ++i;
            }
        } else if (bounds.height < this.numNorth) {
            for (i = 0; i < this.numEast; ++i) {
                for (j = bounds.height; j < this.numNorth; ++j) {
                    this.grid[i][j] = null;
                }
            }
        }
        if (bounds.y > this.northOffset) {
            int diff = bounds.y - this.northOffset;
            num_copy = bounds.height - diff;
            for (i = 0; i < bounds.width; ++i) {
                System.arraycopy(this.grid[i], diff, this.grid[i], 0, num_copy);
                for (j = diff; j < this.numNorth; ++j) {
                    this.grid[i][j] = null;
                }
            }
        } else if (bounds.y < this.northOffset) {
            int diff = this.northOffset - bounds.y;
            num_copy = bounds.height - diff;
            for (i = 0; i < bounds.width; ++i) {
                System.arraycopy(this.grid[i], 0, this.grid[i], diff, num_copy);
                for (j = 0; j < diff; ++j) {
                    this.grid[i][j] = null;
                }
            }
        }
        if (bounds.x > this.eastOffset) {
            int diff = bounds.x - this.eastOffset;
            num_copy = bounds.height - diff;
            for (i = 0; i < diff; ++i) {
                System.arraycopy(this.grid[i], 0, this.grid[i + 1], 0, this.numNorth);
            }
            while (i < bounds.width) {
                for (j = 0; j < bounds.height; ++j) {
                    this.grid[i][j] = null;
                }
                ++i;
            }
        } else if (bounds.x < this.eastOffset) {
            int diff = this.eastOffset - bounds.x;
            num_copy = bounds.height - diff;
            for (i = diff; i <= bounds.width - diff; ++i) {
                System.arraycopy(this.grid[i - 1], 0, this.grid[i], 0, this.numNorth);
            }
            for (i = 0; i < diff; ++i) {
                for (j = 0; j < bounds.height; ++j) {
                    this.grid[i][j] = null;
                }
            }
        }
        this.numEast = bounds.width;
        this.numNorth = bounds.height;
        this.eastOffset = bounds.x;
        this.northOffset = bounds.y;
    }

    void addPatch(ROAMPatch p, int tileX, int tileY) {
        ROAMPatch tp;
        int local_x = tileX - this.eastOffset;
        int local_y = tileY - this.northOffset;
        this.grid[local_x][local_y] = p;
        if (local_x != 0) {
            tp = this.grid[local_x - 1][local_y];
            p.setWestNeighbour(tp);
            if (tp != null) {
                tp.setEastNeighbour(p);
            }
        }
        if (local_x < this.numEast - 1) {
            tp = this.grid[local_x + 1][local_y];
            if (tp != null) {
                tp.setWestNeighbour(p);
            }
            p.setEastNeighbour(tp);
        }
        if (local_y != 0) {
            tp = this.grid[local_x][local_y - 1];
            p.setSouthNeighbour(tp);
            if (tp != null) {
                tp.setNorthNeighbour(p);
            }
        }
        if (local_y < this.numNorth - 1) {
            tp = this.grid[local_x][local_y + 1];
            if (tp != null) {
                tp.setSouthNeighbour(p);
            }
            p.setNorthNeighbour(tp);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("PatchGrid:\n");
        buf.append("Size: ");
        buf.append(this.numEast);
        buf.append(' ');
        buf.append(this.numNorth);
        buf.append("\nOffsets: ");
        buf.append(this.eastOffset);
        buf.append(' ');
        buf.append(this.northOffset);
        for (int i = this.numNorth - 1; i >= 0; --i) {
            buf.append('\n');
            for (int j = 0; j < this.numEast; ++j) {
                if (this.grid[j][i] == null) {
                    buf.append('0');
                } else {
                    buf.append(this.grid[j][i].hashCode());
                }
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public String toRelationsString() {
        StringBuffer buf = new StringBuffer("PatchGrid Relations:");
        for (int i = this.numNorth - 1; i >= 0; --i) {
            buf.append('\n');
            for (int j = 0; j < this.numEast; ++j) {
                if (this.grid[j][i] == null) {
                    buf.append('0');
                } else {
                    buf.append(this.grid[j][i].toString2());
                }
                buf.append("  ");
            }
        }
        return buf.toString();
    }
}

