/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Point;
import org.j3d.maths.vector.Point3d;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.VarianceTree;
import org.j3d.terrain.roam.VertexData;
import org.j3d.util.frustum.ViewFrustum;

public abstract class ROAMPatch {
    protected final int PATCH_SIZE;
    protected TreeNode NWTree;
    protected TreeNode SETree;
    private VarianceTree NWVariance;
    private VarianceTree SEVariance;
    private int xOrigin;
    private int yOrigin;
    private int patchX;
    private int patchY;
    protected Point tileOrigin;
    protected TerrainData terrainData;
    protected ViewFrustum viewFrustum;
    private ROAMPatch northNeighbour;
    private ROAMPatch southNeighbour;
    private ROAMPatch eastNeighbour;
    private ROAMPatch westNeighbour;
    protected VertexData vertexData;
    protected float maxY;
    protected float minY;
    protected boolean resetRequested;
    private boolean firstUse;

    protected ROAMPatch(TerrainData terrain, int patchSize, ViewFrustum frustum, int patchX, int patchY) {
        this.PATCH_SIZE = patchSize;
        this.terrainData = terrain;
        this.viewFrustum = frustum;
        this.patchX = patchX;
        this.patchY = patchY;
        this.firstUse = false;
        this.tileOrigin = new Point();
    }

    void setView(Point3d position, ViewFrustum frustum, QueueManager queueManager) {
        if (this.NWTree == null) {
            return;
        }
        this.viewFrustum = frustum;
        try {
            this.NWTree.updateTree(position, frustum, this.NWVariance, -1, queueManager);
        }
        catch (RuntimeException re) {
            System.out.println("NW tree " + this.hashCode());
        }
        try {
            this.SETree.updateTree(position, frustum, this.SEVariance, -1, queueManager);
        }
        catch (RuntimeException re) {
            System.out.println("NW tree " + this.hashCode());
        }
    }

    public abstract void updateGeometry();

    public void clear() {
        this.resetRequested = true;
        this.vertexData.reset();
        this.NWTree.freeNode();
        this.SETree.freeNode();
        this.NWTree = null;
        this.SETree = null;
        this.setNorthNeighbour(null);
        this.setSouthNeighbour(null);
        this.setEastNeighbour(null);
        this.setWestNeighbour(null);
    }

    protected void setOrigin(int xOrig, int yOrig) {
        this.tileOrigin.x = xOrig / this.PATCH_SIZE;
        this.tileOrigin.y = yOrig / this.PATCH_SIZE;
        this.xOrigin = xOrig;
        this.yOrigin = yOrig;
        int height = this.yOrigin + this.PATCH_SIZE;
        int width = this.xOrigin + this.PATCH_SIZE;
        this.NWVariance = new VarianceTree(this.terrainData, this.PATCH_SIZE, this.xOrigin, this.yOrigin, width, height, this.xOrigin, height);
        this.SEVariance = new VarianceTree(this.terrainData, this.PATCH_SIZE, width, height, this.xOrigin, this.yOrigin, width, this.yOrigin);
        this.NWTree = TreeNode.getTreeNode();
        this.SETree = TreeNode.getTreeNode();
        this.NWTree.newNode(this.xOrigin, this.yOrigin, width, height, this.xOrigin, height, 1, this.terrainData, this.viewFrustum, -1, 1, this.NWVariance, this.patchX, this.patchY);
        this.SETree.newNode(width, height, this.xOrigin, this.yOrigin, width, this.yOrigin, 1, this.terrainData, this.viewFrustum, -1, 1, this.SEVariance, this.patchX, this.patchY);
        this.maxY = Math.max(this.NWVariance.getMaxY(), this.SEVariance.getMaxY());
        this.minY = Math.min(this.NWVariance.getMinY(), this.SEVariance.getMinY());
        this.NWTree.baseNeighbour = this.SETree;
        this.SETree.baseNeighbour = this.NWTree;
    }

    void reset() {
        this.NWTree.reset(this.viewFrustum);
        this.SETree.reset(this.viewFrustum);
        this.NWTree.baseNeighbour = this.SETree;
        this.SETree.baseNeighbour = this.NWTree;
    }

    void setNorthNeighbour(ROAMPatch p) {
        this.northNeighbour = p;
    }

    void setSouthNeighbour(ROAMPatch p) {
        this.southNeighbour = p;
        if (this.southNeighbour != null) {
            this.SETree.rightNeighbour = this.southNeighbour.NWTree;
            this.southNeighbour.NWTree.rightNeighbour = this.SETree;
        }
    }

    void setEastNeighbour(ROAMPatch p) {
        this.eastNeighbour = p;
    }

    void setWestNeighbour(ROAMPatch p) {
        this.westNeighbour = p;
        if (this.westNeighbour != null) {
            this.NWTree.leftNeighbour = this.westNeighbour.SETree;
            this.westNeighbour.SETree.leftNeighbour = this.NWTree;
        }
    }

    void updateEdges(Point3d position, QueueManager queueManager) {
        int old = -1;
        int neu = -1;
        if (this.southNeighbour != null) {
            while (old != 0 && neu != 0) {
                neu = this.SETree.edgeSplit(this.southNeighbour.NWTree, 3, position, this.viewFrustum, queueManager);
                old = this.southNeighbour.NWTree.edgeSplit(this.SETree, 2, position, this.viewFrustum, queueManager);
            }
        }
        if (this.northNeighbour != null) {
            old = -1;
            neu = -1;
            while (old != 0 && neu != 0) {
                neu = this.NWTree.edgeSplit(this.northNeighbour.SETree, 2, position, this.viewFrustum, queueManager);
                old = this.northNeighbour.SETree.edgeSplit(this.NWTree, 3, position, this.viewFrustum, queueManager);
            }
        }
        if (this.eastNeighbour != null) {
            old = -1;
            neu = -1;
            while (old != 0 && neu != 0) {
                neu = this.SETree.edgeSplit(this.eastNeighbour.NWTree, 2, position, this.viewFrustum, queueManager);
                old = this.eastNeighbour.NWTree.edgeSplit(this.SETree, 3, position, this.viewFrustum, queueManager);
            }
        }
        if (this.westNeighbour != null) {
            old = -1;
            neu = -1;
            while (old != 0 && neu != 0) {
                neu = this.NWTree.edgeSplit(this.westNeighbour.SETree, 3, position, this.viewFrustum, queueManager);
                old = this.westNeighbour.SETree.edgeSplit(this.NWTree, 2, position, this.viewFrustum, queueManager);
            }
        }
    }

    void makeActive() {
        this.resetRequested = false;
    }

    Point getTileOrigin() {
        return this.tileOrigin;
    }

    int getTriangleCount() {
        return this.vertexData.getVertexCount() / 3;
    }

    protected void createGeometry() {
        this.vertexData.reset();
        if (this.NWTree.visible != 2) {
            this.NWTree.getTriangles(this.vertexData);
        }
        if (this.SETree.visible != 2) {
            this.SETree.getTriangles(this.vertexData);
        }
    }

    public String toString2() {
        StringBuilder buf = new StringBuilder();
        if (this.westNeighbour != null) {
            buf.append(this.westNeighbour.hashCode());
        } else {
            buf.append("-1");
        }
        buf.append(',');
        if (this.southNeighbour != null) {
            buf.append(this.southNeighbour.hashCode());
        } else {
            buf.append("-1");
        }
        return buf.toString();
    }
}

