/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import org.j3d.maths.vector.Point3d;
import org.j3d.maths.vector.Vector3d;
import org.j3d.terrain.FreeFormTerrainData;
import org.j3d.terrain.Landscape;
import org.j3d.terrain.StaticTerrainData;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.TiledTerrainData;
import org.j3d.terrain.roam.PatchGrid;
import org.j3d.terrain.roam.ROAMPatch;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.TreeQueueManager;
import org.j3d.util.I18nManager;
import org.j3d.util.frustum.ViewFrustum;

public abstract class ROAMSplitMergeLandscape
extends Landscape {
    private static final String NEG_PATCH_SIZE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.negPatchSizeMsg";
    private static final String NOT_POW2_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.pow2PatchSizeMsg";
    private static final String GRID_W_SIZE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.gridWidthSizeMsg";
    private static final String GRID_D_SIZE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.gridDepthSizeMsg";
    private static final String INV_TERRAIN_TYPE_MSG_PROP = "org.j3d.terrain.roam.ROAMSplitMergeLandscape.unknownTerrainTypeMsg";
    private static final int DEFAULT_PATCH_SIZE = 65;
    private static final int AXIS_TILE_COUNT = 7;
    protected final int patchSize;
    private final int invPatchSize;
    private final int terrainDataType;
    private final float accuracy;
    private ArrayList<ROAMPatch> patches = new ArrayList();
    private TreeQueueManager queueManager = new TreeQueueManager();
    private int triCount = 0;
    private Point3d maxViewBound;
    private Point3d minViewBound;
    private Rectangle oldTileBounds;
    private Rectangle reqdBounds;
    private LinkedList<ROAMPatch> freePatchList;
    private ArrayList<ROAMPatch> tempPatchList;
    private PatchGrid patchGrid;

    public ROAMSplitMergeLandscape(ViewFrustum view, TerrainData data) {
        super(view, data);
        this.terrainDataType = data.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(data, 65);
        this.invPatchSize = 1 / this.patchSize;
    }

    public ROAMSplitMergeLandscape(ViewFrustum view, TerrainData data, int patchSize) {
        super(view, data);
        if (patchSize <= 0) {
            I18nManager intl_mgr = I18nManager.getManager();
            String msg = intl_mgr.getString(NEG_PATCH_SIZE_MSG_PROP);
            throw new IllegalArgumentException(msg);
        }
        if (!this.power2Check(patchSize - 1)) {
            I18nManager intl_mgr = I18nManager.getManager();
            String msg = intl_mgr.getString(NOT_POW2_MSG_PROP);
            throw new IllegalArgumentException(msg);
        }
        this.terrainDataType = data.getSourceDataType();
        this.accuracy = (float)Math.toRadians(0.1);
        this.patchSize = this.init(data, patchSize);
        this.invPatchSize = 1 / patchSize;
    }

    @Override
    public void initialize(Point3d position, Vector3d direction) {
        this.landscapeView.viewingPlatformMoved();
        switch (this.terrainDataType) {
            case 1: {
                this.createStaticPatches();
                break;
            }
            case 2: {
                this.minViewBound = new Point3d();
                this.maxViewBound = new Point3d();
                this.reqdBounds = new Rectangle();
                this.oldTileBounds = new Rectangle();
                this.freePatchList = new LinkedList();
                this.tempPatchList = new ArrayList();
                this.createTiledPatches(position, direction);
                break;
            }
            case 3: {
                this.createFreeFormPatches();
            }
        }
        this.setView(position, direction);
    }

    @Override
    public void setView(Point3d position, Vector3d direction) {
        ROAMPatch p;
        int i;
        this.queueManager.clear();
        this.landscapeView.viewingPlatformMoved();
        switch (this.terrainDataType) {
            case 2: {
                if (this.calculateViewTileBounds(position, direction)) break;
                this.patchGrid.prepareNewBounds(this.reqdBounds);
                this.clearOldTiledPatches();
                this.loadNewTiles(position);
                this.oldTileBounds.setBounds(this.reqdBounds);
                break;
            }
        }
        int size = this.patches.size();
        for (i = 0; i < size; ++i) {
            p = this.patches.get(i);
            p.setView(position, this.landscapeView, this.queueManager);
        }
        boolean done = false;
        while (!done) {
            TreeNode splitCandidate = this.queueManager.getSplitCandidate();
            TreeNode mergeCandidate = this.queueManager.getMergeCandidate();
            if (mergeCandidate == null && splitCandidate != null) {
                if (splitCandidate.variance > this.accuracy) {
                    splitCandidate.forceSplit(position, this.landscapeView, this.queueManager);
                    continue;
                }
                done = true;
                continue;
            }
            if (mergeCandidate != null && splitCandidate == null) {
                if (mergeCandidate.variance < this.accuracy) {
                    mergeCandidate.merge(this.queueManager);
                    continue;
                }
                done = true;
                continue;
            }
            if (mergeCandidate != null && splitCandidate != null && (splitCandidate.variance > this.accuracy || splitCandidate.variance > mergeCandidate.variance)) {
                if (splitCandidate.variance > this.accuracy) {
                    splitCandidate.forceSplit(position, this.landscapeView, this.queueManager);
                    continue;
                }
                if (!(mergeCandidate.variance < this.accuracy)) continue;
                mergeCandidate.merge(this.queueManager);
                continue;
            }
            done = true;
        }
        for (i = 0; i < size; ++i) {
            p = this.patches.get(i);
            p.updateGeometry();
        }
        this.queueManager.clear();
    }

    protected abstract ROAMPatch createPatch(int var1, int var2, int var3, int var4);

    protected abstract void updatePatch(ROAMPatch var1, int var2, int var3);

    protected abstract void addPatch(ROAMPatch var1);

    private int init(TerrainData data, int ps) {
        int ret_val = ps;
        switch (this.terrainDataType) {
            case 1: {
                StaticTerrainData s_data = (StaticTerrainData)data;
                int w = s_data.getGridWidth();
                int h = s_data.getGridDepth();
                if (!this.checkPatchSide(w, ps)) {
                    I18nManager intl_mgr = I18nManager.getManager();
                    String msg = intl_mgr.getString(GRID_W_SIZE_MSG_PROP) + w;
                    throw new IllegalArgumentException(msg);
                }
                if (this.checkPatchSide(h, ps)) break;
                I18nManager intl_mgr = I18nManager.getManager();
                String msg = intl_mgr.getString(GRID_D_SIZE_MSG_PROP) + h;
                throw new IllegalArgumentException(msg);
            }
            case 3: {
                break;
            }
            case 2: {
                ret_val = ((TiledTerrainData)data).getTileSize();
                break;
            }
            default: {
                ret_val = 0;
                I18nManager intl_mgr = I18nManager.getManager();
                String msg = intl_mgr.getString(INV_TERRAIN_TYPE_MSG_PROP);
                System.out.println(msg);
            }
        }
        return ret_val;
    }

    private void createTiledPatches(Point3d position, Vector3d direction) {
        TiledTerrainData t_data = (TiledTerrainData)this.terrainData;
        this.calculateViewTileBounds(position, direction);
        t_data.setActiveBounds(this.reqdBounds);
        this.oldTileBounds.setBounds(this.reqdBounds);
        this.patchGrid = new PatchGrid(this.reqdBounds);
        ROAMPatch p = null;
        int east = this.reqdBounds.x * this.patchSize;
        int x_tile = this.reqdBounds.x;
        int e_grid = east;
        for (int i = 0; i < this.reqdBounds.width; ++i) {
            int north = this.reqdBounds.y * this.patchSize;
            int y_tile = this.reqdBounds.y;
            int n_grid = north;
            for (int j = 0; j < this.reqdBounds.height; ++j) {
                p = this.createPatch(i, j, x_tile, y_tile);
                p.setOrigin(e_grid, n_grid);
                this.patchGrid.addPatch(p, x_tile, y_tile);
                p.makeActive();
                this.patches.add(p);
                this.triCount += 2;
                this.addPatch(p);
                ++y_tile;
                ++north;
                n_grid += this.patchSize;
            }
            ++x_tile;
            ++east;
            e_grid += this.patchSize;
        }
    }

    private void createFreeFormPatches() {
        FreeFormTerrainData t_data = (FreeFormTerrainData)this.terrainData;
        System.out.println("Free-form terrain not implemented yet");
    }

    private void createStaticPatches() {
        StaticTerrainData t_data = (StaticTerrainData)this.terrainData;
        int depth = t_data.getGridDepth() - this.patchSize;
        int width = t_data.getGridWidth() - this.patchSize;
        if (depth < 0 || width < 0) {
            throw new IllegalArgumentException("ROAMPatch size is greater than the grid cell size");
        }
        ROAMPatch[] westPatchNeighbour = new ROAMPatch[width];
        ROAMPatch southPatchNeighbour = null;
        ROAMPatch p = null;
        if (width == 0) {
            for (int north = 0; north <= depth; north += this.patchSize) {
                p = this.createPatch(0, north, 0, 0);
                p.setOrigin(0, north);
                p.setSouthNeighbour(southPatchNeighbour);
                p.makeActive();
                this.patches.add(p);
                this.triCount += 2;
                this.addPatch(p);
                southPatchNeighbour = p;
            }
            southPatchNeighbour = null;
        } else {
            for (int east = 0; east <= width; east += this.patchSize) {
                for (int north = 0; north <= depth; north += this.patchSize) {
                    int w_pos = north * this.invPatchSize;
                    p = this.createPatch(east, north, 0, 0);
                    p.setOrigin(east, north);
                    p.setWestNeighbour(westPatchNeighbour[w_pos]);
                    p.setSouthNeighbour(southPatchNeighbour);
                    p.makeActive();
                    this.patches.add(p);
                    this.triCount += 2;
                    this.addPatch(p);
                    southPatchNeighbour = p;
                    westPatchNeighbour[w_pos] = p;
                }
                southPatchNeighbour = null;
            }
        }
    }

    private boolean power2Check(int val) {
        int shift_val = val;
        while ((shift_val & 1) == 0) {
            shift_val >>= 1;
        }
        return (shift_val | 1) == 1;
    }

    private boolean checkPatchSide(int size, int ps) {
        int val = size - 1;
        return val % ps == 0;
    }

    private boolean calculateViewTileBounds(Point3d position, Vector3d direction) {
        TiledTerrainData t_data = (TiledTerrainData)this.terrainData;
        float x_spacing = (float)t_data.getGridXStep();
        float y_spacing = (float)t_data.getGridYStep();
        int tile_size = t_data.getTileSize();
        float[] origin = new float[3];
        t_data.getCoordinate(origin, 0, 0);
        double cur_x = position.x - (double)origin[0];
        double cur_z = (double)origin[2] - position.z;
        int tile_x = (int)Math.floor(cur_x / (double)(x_spacing * (float)tile_size));
        int tile_y = (int)Math.floor(cur_z / (double)(y_spacing * (float)tile_size));
        if (direction.x == 0.0 && direction.z == 0.0) {
            tile_x -= 3;
            tile_y -= 3;
        } else {
            double aspect = Math.abs(direction.x / direction.z);
            if (direction.x >= 0.0) {
                if (direction.z <= 0.0) {
                    if (aspect < 0.5) {
                        --tile_x;
                    } else if (aspect > 2.0) {
                        --tile_y;
                    }
                } else {
                    --tile_y;
                    if (aspect < 0.5) {
                        --tile_x;
                    }
                }
            } else if (direction.z <= 0.0) {
                --tile_x;
                if (aspect > 2.0) {
                    --tile_y;
                }
            } else {
                --tile_x;
                --tile_y;
            }
            this.reqdBounds.x = tile_x;
            this.reqdBounds.y = tile_y;
            this.reqdBounds.width = 7;
            this.reqdBounds.height = 7;
        }
        return this.oldTileBounds.equals(this.reqdBounds);
    }

    private void clearOldTiledPatches() {
        int size = this.patches.size();
        boolean patch_removed = false;
        for (int i = 0; i < size; ++i) {
            ROAMPatch p = this.patches.get(i);
            if (this.reqdBounds.contains(p.getTileOrigin())) continue;
            p.clear();
            this.freePatchList.add(p);
            this.tempPatchList.add(p);
            patch_removed = true;
        }
        if (patch_removed) {
            this.patches.removeAll(this.tempPatchList);
            this.tempPatchList.clear();
        }
    }

    private void loadNewTiles(Point3d position) {
        int n_grid;
        int north;
        int e_grid;
        int east;
        TiledTerrainData td;
        ROAMPatch p = null;
        float invPatchSize = 1.0f / (float)this.patchSize;
        int start_east = 0;
        int start_north = 0;
        int diff = this.reqdBounds.x - this.oldTileBounds.x;
        start_east = diff <= 0 ? this.reqdBounds.x : this.reqdBounds.x + this.reqdBounds.width - diff;
        int num_east = Math.abs(diff);
        diff = this.reqdBounds.y - this.oldTileBounds.y;
        start_north = diff <= 0 ? this.reqdBounds.y : this.reqdBounds.y + this.reqdBounds.height - diff;
        int num_north = Math.abs(diff);
        int i = 0;
        int j = 0;
        if (num_north != 0) {
            td = (TiledTerrainData)this.terrainData;
            east = this.oldTileBounds.x - 1;
            e_grid = east * this.patchSize;
            for (i = 0; i < this.reqdBounds.width; ++i) {
                e_grid += this.patchSize;
                ++east;
                north = start_north;
                n_grid = (north - 1) * this.patchSize;
                for (j = 0; j < num_north; ++j) {
                    n_grid += this.patchSize;
                    if (this.freePatchList.size() == 0) {
                        p = this.createPatch(i, j, east, north);
                        this.addPatch(p);
                    } else {
                        p = this.freePatchList.remove(0);
                        this.updatePatch(p, east, north);
                    }
                    this.tempPatchList.add(p);
                    p.setOrigin(e_grid, n_grid);
                    this.patchGrid.addPatch(p, east, north);
                    p.makeActive();
                    p.reset();
                    this.patches.add(p);
                    this.triCount += 2;
                    ++north;
                }
            }
        }
        if (num_east != 0) {
            east = start_east - 1;
            num_north = this.reqdBounds.height;
            td = (TiledTerrainData)this.terrainData;
            e_grid = east * this.patchSize;
            for (i = 0; i < num_east; ++i) {
                e_grid += this.patchSize;
                north = start_north;
                n_grid = (north - 1) * this.patchSize;
                ++east;
                for (j = 0; j < num_north; ++j) {
                    int w_pos = (int)((float)north * invPatchSize);
                    n_grid += this.patchSize;
                    if (this.freePatchList.size() == 0) {
                        p = this.createPatch(i, j, east, north);
                        this.addPatch(p);
                    } else {
                        p = this.freePatchList.remove(0);
                        this.updatePatch(p, east, north);
                    }
                    this.tempPatchList.add(p);
                    p.setOrigin(e_grid, n_grid);
                    this.patchGrid.addPatch(p, east, north);
                    p.makeActive();
                    p.reset();
                    this.patches.add(p);
                    this.triCount += 2;
                    ++north;
                }
            }
        }
        int size = this.tempPatchList.size();
        for (i = 0; i < size; ++i) {
            p = this.tempPatchList.get(i);
            p.updateEdges(position, this.queueManager);
        }
        this.tempPatchList.clear();
    }
}

