/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import org.j3d.terrain.TerrainData;

class VarianceTree {
    private int[] vTree;
    private int maxLevels;
    private float maxY = -3.4028235E38f;
    private float minY = Float.MAX_VALUE;

    VarianceTree(TerrainData terrainData, int patchSize, int leftX, int leftY, int rightX, int rightY, int apexX, int apexY) {
        this.maxLevels = (int)Math.sqrt(patchSize);
        this.vTree = new int[1 << this.maxLevels];
        this.computeVariance(terrainData, leftX, leftY, rightX, rightY, apexX, apexY, 1, 0);
    }

    float computeVariance(TerrainData terrainData, int leftX, int leftY, int rightX, int rightY, int apexX, int apexY, int node, int level) {
        int splitX = leftX + rightX >> 1;
        int splitY = leftY + rightY >> 1;
        float actualHeight = terrainData.getHeightFromGrid(splitX, splitY);
        if (actualHeight > this.maxY) {
            this.maxY = actualHeight;
        }
        if (actualHeight < this.minY) {
            this.minY = actualHeight;
        }
        float l_height = terrainData.getHeightFromGrid(leftX, leftY);
        float r_height = terrainData.getHeightFromGrid(rightX, rightY);
        float variance = Math.abs(actualHeight - (l_height + r_height) * 0.5f);
        if (level < this.maxLevels - 1) {
            float var = this.computeVariance(terrainData, apexX, apexY, leftX, leftY, splitX, splitY, node << 1, level + 1);
            variance = Math.max(variance, var);
            var = this.computeVariance(terrainData, rightX, rightY, apexX, apexY, splitX, splitY, 1 + (node << 1), level + 1);
            variance = Math.max(variance, var);
        }
        this.vTree[node] = 1 + (int)variance;
        return variance;
    }

    int getVariance(int node) {
        return this.vTree[node];
    }

    int getMaxDepth() {
        return this.maxLevels;
    }

    float getMaxY() {
        return this.maxY;
    }

    float getMinY() {
        return this.minY;
    }
}

