/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.jackstaff.grpc.annotation.AsynchronousUnary;
import org.jackstaff.grpc.annotation.BidiStreaming;
import org.jackstaff.grpc.annotation.BlockingServerStreaming;
import org.jackstaff.grpc.annotation.ClientStreaming;
import org.jackstaff.grpc.annotation.Protocol;
import org.jackstaff.grpc.annotation.ServerStreaming;
import org.jackstaff.grpc.generator.MethodInfo;
import org.jackstaff.grpc.generator.TransFormInfos;
import org.jackstaff.grpc.generator.Utils;

class ProtocolInfo {
    private final ProcessingEnvironment processingEnv;
    private final TransFormInfos transForms;
    private final String serviceName;
    private final TypeElement grpc;
    private final List<MethodInfo> methods;
    private TypeSpec.Builder builder;

    public ProtocolInfo(ProcessingEnvironment processingEnv, TransFormInfos transForms, String serviceName, TypeElement grpc, List<MethodInfo> methods) {
        this.processingEnv = processingEnv;
        this.transForms = transForms;
        this.serviceName = serviceName;
        this.grpc = grpc;
        this.methods = methods;
    }

    private String simpleName() {
        String name = this.serviceName.contains(".") ? this.serviceName.substring(this.serviceName.lastIndexOf(".") + 1) : this.serviceName;
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public void build() {
        this.builder = TypeSpec.interfaceBuilder((String)this.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Protocol.class);
        block10: for (MethodInfo method : this.methods) {
            MethodSpec.Builder spec = MethodSpec.methodBuilder((String)method.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            switch (method.getMethodType()) {
                case UNARY: {
                    spec.returns(method.response()).addParameter(Utils.parameter(method.request()));
                    break;
                }
                case SERVER_STREAMING: {
                    spec.addAnnotation(ServerStreaming.class);
                    spec.addParameter(Utils.parameter(method.request())).addParameter(Utils.responseParameter(method));
                    break;
                }
                case CLIENT_STREAMING: {
                    spec.addAnnotation(ClientStreaming.class);
                    spec.returns(Utils.consumerTypeName(method.request())).addParameter(Utils.responseParameter(method));
                    break;
                }
                case BIDI_STREAMING: {
                    spec.addAnnotation(BidiStreaming.class);
                    spec.returns(Utils.consumerTypeName(method.request())).addParameter(Utils.responseParameter(method));
                }
            }
            this.builder.addMethod(spec.build());
            MethodSpec.Builder peer = MethodSpec.methodBuilder((String)method.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
            switch (method.getMethodType()) {
                case UNARY: {
                    peer.addAnnotation(AsynchronousUnary.class);
                    peer.addComment("AsynchronousUnary for overload " + method.getMethodName() + ". do NOT implement it.", new Object[0]).addParameter(Utils.parameter(method.request())).addParameter(Utils.responseParameter(method));
                    break;
                }
                case SERVER_STREAMING: {
                    peer.addAnnotation(BlockingServerStreaming.class);
                    peer.addComment("BlockingServerStreaming for overload " + method.getMethodName() + ". do NOT implement it.", new Object[0]).returns(Utils.listTypeName(method.response())).addParameter(Utils.parameter(method.request())).addStatement("return null", new Object[0]);
                    break;
                }
                default: {
                    continue block10;
                }
            }
            this.builder.addMethod(peer.build());
        }
        this.builder.addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.addProtocol($N.class, $T.getServiceDescriptor())", new Object[]{this.transForms.findRegistry(Utils.packageName(this.grpc)), this.simpleName(), this.grpc.asType()}).build());
    }

    public void write() {
        Utils.write(this.processingEnv, this.grpc, this.builder);
    }
}

