/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.grpc.ServiceDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import org.jackstaff.grpc.TransFormRegistry;
import org.jackstaff.grpc.generator.ProtoKind;
import org.jackstaff.grpc.generator.TransFormInfo;
import org.jackstaff.grpc.generator.Utils;
import org.jackstaff.grpc.internal.PropertyKind;

class RegistryMapping {
    static final String SIMPLE_CLASS_NAME = "RegistryMapping";
    private final ProcessingEnvironment processingEnv;
    private final String packageName;
    private final String simpleName;
    private TypeSpec.Builder builder;

    public RegistryMapping(ProcessingEnvironment processingEnv, String packageName, String simpleName) {
        this.processingEnv = processingEnv;
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassName selfClassName() {
        return ClassName.get((String)this.packageName, (String)this.simpleName, (String[])new String[0]);
    }

    public boolean hasBuilder() {
        return this.builder != null;
    }

    public void write() {
        if (this.builder != null) {
            Utils.write(this.processingEnv, this.packageName, this.builder);
        }
    }

    public void build(List<TransFormInfo> infos) {
        this.builder = TypeSpec.classBuilder((ClassName)this.selfClassName());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"addProtocol").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(String.class).addParameter(ParameterizedTypeName.get(Class.class), "protocol", new Modifier[0]).addParameter(ServiceDescriptor.class, "descriptor", new Modifier[0]).addStatement("return $T.addProtocol(protocol, descriptor)", new Object[]{TransFormRegistry.class});
        this.builder.addMethod(spec.build());
        infos.stream().sorted((info1, info2) -> {
            if (info1.getProtoKind() == info2.getProtoKind() && info1.getProtoKind() == ProtoKind.MESSAGE) {
                List props1 = info1.getProperties().values().stream().filter(p -> p.getKind() == PropertyKind.MESSAGE || p.getKind() == PropertyKind.MESSAGE_LIST).collect(Collectors.toList());
                List props2 = info2.getProperties().values().stream().filter(p -> p.getKind() == PropertyKind.MESSAGE || p.getKind() == PropertyKind.MESSAGE_LIST).collect(Collectors.toList());
                if (props1.isEmpty() && props2.isEmpty()) {
                    return info1.getProperties().size() - info2.getProperties().size();
                }
                if (props1.size() == props2.size()) {
                    return info1.selfClassName().toString().length() - info2.selfClassName().toString().length();
                }
                return props1.size() - props2.size();
            }
            return info1.getProtoKind().ordinal() - info2.getProtoKind().ordinal();
        }).map(TransFormInfo::getRegistryCodeBlock).filter(Objects::nonNull).forEach(block -> this.builder.addStaticBlock(block.build()));
    }
}

