/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.jackstaff.grpc.MethodType;
import org.jackstaff.grpc.annotation.Protocol;
import org.jackstaff.grpc.annotation.RpcMethod;
import org.jackstaff.grpc.generator.MethodInfo;
import org.jackstaff.grpc.generator.TransFormInfo;
import org.jackstaff.grpc.generator.TransFormInfos;
import org.jackstaff.grpc.generator.Utils;

class ProtocolInfo {
    private final ProcessingEnvironment processingEnv;
    private final TransFormInfos transForms;
    private final String serviceName;
    private final TypeElement grpc;
    private final List<MethodInfo> methods;
    private TypeSpec.Builder builder;

    public ProtocolInfo(ProcessingEnvironment processingEnv, TransFormInfos transForms, String serviceName, TypeElement grpc, List<MethodInfo> methods) {
        this.processingEnv = processingEnv;
        this.transForms = transForms;
        this.serviceName = serviceName;
        this.grpc = grpc;
        this.methods = methods;
    }

    Set<TransFormInfo> dependencies() {
        return this.methods.stream().flatMap(method -> Stream.of(method.requestElement(), method.responseElement())).distinct().map(this.transForms::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private String simpleName() {
        String name = this.serviceName.contains(".") ? this.serviceName.substring(this.serviceName.lastIndexOf(".") + 1) : this.serviceName;
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public String packageName() {
        return Utils.packageName(this.grpc);
    }

    public void build() {
        this.builder = TypeSpec.interfaceBuilder((String)this.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Protocol.class);
        block10: for (MethodInfo method : this.methods) {
            MethodSpec.Builder spec = MethodSpec.methodBuilder((String)method.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            switch (method.getMethodType()) {
                case UNARY: {
                    spec.addAnnotation(AnnotationSpec.builder(RpcMethod.class).addMember("methodType", "$T.UNARY", new Object[]{MethodType.class}).build());
                    spec.returns(method.response()).addParameter(Utils.parameter(method.request()));
                    break;
                }
                case SERVER_STREAMING: {
                    spec.addAnnotation(AnnotationSpec.builder(RpcMethod.class).addMember("methodType", "$T.SERVER_STREAMING", new Object[]{MethodType.class}).build());
                    spec.addParameter(Utils.parameter(method.request())).addParameter(Utils.responseParameter(method));
                    break;
                }
                case CLIENT_STREAMING: {
                    spec.addAnnotation(AnnotationSpec.builder(RpcMethod.class).addMember("methodType", "$T.CLIENT_STREAMING", new Object[]{MethodType.class}).build());
                    spec.returns(Utils.consumerTypeName(method.request())).addParameter(Utils.responseParameter(method));
                    break;
                }
                case BIDI_STREAMING: {
                    spec.addAnnotation(AnnotationSpec.builder(RpcMethod.class).addMember("methodType", "$T.BIDI_STREAMING", new Object[]{MethodType.class}).build());
                    spec.returns(Utils.consumerTypeName(method.request())).addParameter(Utils.responseParameter(method));
                }
            }
            this.builder.addMethod(spec.build());
            MethodSpec.Builder peer = MethodSpec.methodBuilder((String)method.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
            switch (method.getMethodType()) {
                case UNARY: {
                    peer.addAnnotation(AnnotationSpec.builder(RpcMethod.class).addMember("methodType", "$T.ASYNCHRONOUS_UNARY", new Object[]{MethodType.class}).build());
                    peer.addParameter(Utils.parameter(method.request())).addParameter(Utils.responseParameter(method)).addStatement("throw new $T(\"Do NOT implement it.\")", new Object[]{RuntimeException.class});
                    break;
                }
                case SERVER_STREAMING: {
                    peer.addAnnotation(AnnotationSpec.builder(RpcMethod.class).addMember("methodType", "$T.BLOCKING_SERVER_STREAMING", new Object[]{MethodType.class}).build());
                    peer.returns(Utils.listTypeName(method.response())).addParameter(Utils.parameter(method.request())).addStatement("throw new $T(\"Do NOT implement it.\")", new Object[]{RuntimeException.class});
                    break;
                }
                default: {
                    continue block10;
                }
            }
            this.builder.addMethod(peer.build());
        }
        this.grpc.getEnclosedElements().stream().filter(t -> t.getKind() == ElementKind.METHOD).map(Element::getSimpleName).filter(name -> "getServiceDescriptor".equals(name.toString())).findAny().ifPresent(name -> this.builder.addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.addProtocol($N.class, $T.$N())", new Object[]{this.transForms.findRegistry(Utils.packageName(this.grpc)), this.simpleName(), this.grpc.asType(), name}).build()));
    }

    public void write() {
        Utils.write(this.processingEnv, this.packageName(), this.builder);
    }
}

