/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class ExecutorInfo {
    private final ExecutableElement element;
    private final String name;
    private final TypeMirror receiverType;
    private final TypeMirror returnType;
    private final TypeKind returnKind;
    private final boolean indexParameter;

    public ExecutorInfo(ExecutableElement element) {
        this.element = element;
        this.name = element.getSimpleName().toString();
        this.receiverType = element.getReceiverType();
        this.returnType = element.getReturnType();
        this.returnKind = this.returnType.getKind();
        this.indexParameter = Optional.of(element.getParameters()).filter(list -> list.size() == 1).map(list -> ((VariableElement)list.get(0)).asType().getKind() == TypeKind.INT).orElse(false);
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public TypeMirror getReceiverType() {
        return this.receiverType;
    }

    public TypeMirror getReturnType() {
        return this.returnType;
    }

    public TypeKind getReturnKind() {
        return this.returnKind;
    }

    public boolean isIndexParameter() {
        return this.indexParameter;
    }
}

