/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.google.protobuf.ByteString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jackstaff.grpc.TransFormRegistry;
import org.jackstaff.grpc.exception.ValidationException;
import org.jackstaff.grpc.generator.ExecutorInfo;
import org.jackstaff.grpc.generator.TransFormInfo;
import org.jackstaff.grpc.generator.TransFormInfos;
import org.jackstaff.grpc.generator.Utils;
import org.jackstaff.grpc.internal.PropertyKind;

class Property {
    private static final Function<String, String> fHas = s -> "has" + s;
    private static final Function<String, String> fGet = s -> "get" + s;
    private static final Function<String, String> fSet = s -> "set" + s;
    private static final Function<String, String> fBytes = s -> "get" + s + "Bytes";
    private static final Function<String, String> fValue = s -> "get" + s + "Value";
    private static final Function<String, String> fValueList = s -> "get" + s + "ValueList";
    private static final Function<String, String> fList = s -> "get" + s + "List";
    private static final Function<String, String> fCount = s -> "get" + s + "Count";
    private static final Function<String, String> fOrBuilder = s -> "get" + s + "OrBuilder";
    private static final Function<String, String> fOrBuilderList = s -> "get" + s + "OrBuilderList";
    private static final Function<String, String> fAddAll = s -> "addAll" + s;
    private static final Function<String, String> fClear = s -> "clear" + s;
    private final TransFormInfos transForms;
    private final TransFormInfo transform;
    private final String name;
    private final PropertyKind kind;
    private final Map<String, ExecutorInfo> executors;
    private Property oneOfCase;
    private Set<String> enumNames;
    private String enumNameSpecial;
    private TypeName typeName;
    private TypeName elementTypeName;
    private PropertyKind elementKind;
    private String fieldName;

    public Property(TransFormInfos transForms, TransFormInfo transform, String name, PropertyKind kind, List<ExecutorInfo> executors) {
        this.transForms = transForms;
        this.transform = transform;
        this.name = name;
        this.kind = kind;
        this.executors = executors.stream().collect(LinkedHashMap::new, (m, e) -> m.put(e.getName(), e), HashMap::putAll);
    }

    public Property(TransFormInfos transForms, TransFormInfo transform, String name, PropertyKind kind, ExecutorInfo info) {
        this(transForms, transform, name, kind, Collections.singletonList(info));
    }

    private String refFieldName() {
        return this.fieldName() + "_";
    }

    private static String UpperName(String name) {
        return name.replaceAll("_", "").toUpperCase();
    }

    private String enumName(String name) {
        return this.enumNames.stream().filter(s -> Property.UpperName(s).equals(Property.UpperName(name))).findFirst().orElse(null);
    }

    public String fieldName() {
        if (this.fieldName == null) {
            this.fieldName = this.fieldNameImp();
        }
        return this.fieldName;
    }

    private String fieldNameImp() {
        return this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
    }

    public String getName() {
        return this.name;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public Map<String, ExecutorInfo> getExecutors() {
        return this.executors;
    }

    public TypeName elementTypeName() {
        if (this.typeName == null) {
            this.typeName = this.typeNameImp();
        }
        return this.elementTypeName;
    }

    public TypeName typeName() {
        if (this.typeName == null) {
            this.typeName = this.typeNameImp();
        }
        return this.typeName;
    }

    TransFormInfo dependency() {
        switch (this.kind) {
            case ENUM: 
            case MESSAGE: 
            case MESSAGE_LIST: 
            case ENUM_LIST: {
                return this.transForms.get(this.findExecutor(fGet).getReturnType());
            }
        }
        return null;
    }

    private TypeName typeNameImp() {
        switch (this.kind.category()) {
            case PRIMITIVE: 
            case STRING: {
                return TypeName.get((Type)this.kind.rawType());
            }
            case BYTES: 
            case WRAPPER: {
                return TypeName.get((Type)this.kind.boxingType());
            }
            case MESSAGE: 
            case ENUM: {
                return this.transForms.get(this.findExecutor(fGet).getReturnType()).pojoTypeName();
            }
            case REPEATED: {
                TypeMirror typeMirror = this.findExecutor(fGet).getReturnType();
                switch (this.kind) {
                    case PRIMITIVE_LIST: {
                        this.elementTypeName = TypeName.get((TypeMirror)typeMirror);
                        return TypeName.get((TypeMirror)this.findExecutor(fList).getReturnType());
                    }
                    case WRAPPER_LIST: {
                        this.elementKind = Arrays.stream(PropertyKind.values()).filter(PropertyKind::isWrapper).filter(k -> this.transForms.isSameType(k.rawType(), typeMirror)).findAny().orElseThrow(() -> new ValidationException("NEVER"));
                        this.elementTypeName = TypeName.get((Type)this.elementKind.boxingType());
                        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName});
                    }
                    case STRING_LIST: {
                        this.elementKind = PropertyKind.STRING;
                        this.elementTypeName = TypeName.get(String.class);
                        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName});
                    }
                    case BYTES_LIST: {
                        this.elementKind = PropertyKind.BYTES;
                        this.elementTypeName = TypeName.get(byte[].class);
                        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName});
                    }
                    case MESSAGE_LIST: 
                    case ENUM_LIST: {
                        this.elementKind = this.kind == PropertyKind.ENUM_LIST ? PropertyKind.ENUM : PropertyKind.MESSAGE;
                        this.elementTypeName = this.transForms.get(typeMirror).pojoTypeName();
                        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.elementTypeName});
                    }
                }
            }
        }
        return TypeName.get((Type)this.kind.rawType());
    }

    private String name(Function<String, String> func) {
        return func.apply(this.name);
    }

    private ExecutorInfo findExecutor(Function<String, String> func) {
        return this.executors.get(func.apply(this.name));
    }

    private void addField(TypeSpec.Builder builder) {
        if (this.oneOfCase == null) {
            builder.addField(FieldSpec.builder((TypeName)this.typeName(), (String)this.fieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        }
        if (this.kind == PropertyKind.ONE_OF_CASE) {
            builder.addField(FieldSpec.builder((TypeName)TypeName.get(Object.class), (String)this.refFieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            builder.addMethod(MethodSpec.methodBuilder((String)fClear.apply(this.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addStatement("this.$N = null", new Object[]{this.fieldName()}).addStatement("this.$N = null", new Object[]{this.refFieldName()}).build());
        }
    }

    private void addGet(TypeSpec.Builder builder) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)fGet.apply(this.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeName());
        if (this.oneOfCase == null) {
            switch (this.kind.category()) {
                case ENUM: {
                    spec.addStatement("return $T.ofNullable(this.$N).orElse($T.$N)", new Object[]{Optional.class, this.fieldName(), this.typeName(), this.enumNameSpecial});
                    break;
                }
                case PRIMITIVE: 
                case WRAPPER: 
                case MESSAGE: {
                    spec.addStatement("return this.$N", new Object[]{this.fieldName()});
                    break;
                }
                case BYTES: {
                    spec.addStatement("return $T.ofNullable(this.$N).orElseGet(()->new byte[0])", new Object[]{Optional.class, this.fieldName()});
                    break;
                }
                case STRING: {
                    spec.addStatement("return $T.ofNullable(this.$N).orElse(\"\")", new Object[]{Optional.class, this.fieldName()});
                    break;
                }
                case REPEATED: {
                    spec.addStatement("return $T.ofNullable(this.$N).orElseGet($T::emptyList)", new Object[]{Optional.class, this.fieldName(), Collections.class});
                }
            }
        } else {
            switch (this.kind.category()) {
                case PRIMITIVE: {
                    spec.addStatement("return this.$N == $T.$N ? ($T)$N : $N", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name), TypeName.get((Type)this.kind.boxingType()), this.oneOfCase.refFieldName(), this.kind.defaultValue().toString()});
                    break;
                }
                case STRING: {
                    spec.addStatement("return this.$N == $T.$N ? ($T)$N : \"\"", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name), this.typeName(), this.oneOfCase.refFieldName()});
                    break;
                }
                case ENUM: {
                    if (this.kind == PropertyKind.ONE_OF_CASE) {
                        this.transForms.error("NEVER: ONE_OF_CASE's ONE_OF_CASE");
                        return;
                    }
                    spec.addStatement("return this.$N == $T.$N ? ($T)$N : $T.$N", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name), this.typeName(), this.oneOfCase.refFieldName(), this.typeName(), this.enumNameSpecial});
                    break;
                }
                case WRAPPER: 
                case MESSAGE: {
                    spec.addStatement("return this.$N == $T.$N ? ($T)$N : null", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name), this.typeName(), this.oneOfCase.refFieldName()});
                    break;
                }
                case BYTES: {
                    spec.addStatement("return this.$N == $T.$N ? ($T)$N : new byte[0]", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name), this.typeName(), this.oneOfCase.refFieldName()});
                    break;
                }
                case REPEATED: {
                    spec.addStatement("return this.$N == $T.$N ? ($T)$N : $T.emptyList()", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name), this.typeName(), this.oneOfCase.refFieldName(), Collections.class});
                }
            }
        }
        builder.addMethod(spec.build());
    }

    private void addSet(TypeSpec.Builder builder) {
        if (this.kind == PropertyKind.ONE_OF_CASE) {
            return;
        }
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)fSet.apply(this.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(this.typeName(), this.fieldName(), new Modifier[0]);
        if (this.oneOfCase == null) {
            spec.addStatement("this.$N = $N", new Object[]{this.fieldName(), this.fieldName()});
        } else {
            switch (this.kind.category()) {
                case PRIMITIVE: {
                    spec.addStatement("this.$N = $T.$N", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name)});
                    spec.addStatement("this.$N = $N", new Object[]{this.oneOfCase.refFieldName(), this.fieldName()});
                    break;
                }
                case ENUM: {
                    spec.addStatement("if ($N == $T.$N) throw new $T(\"$N must not be unknown value\")", new Object[]{this.fieldName(), this.typeName(), this.enumNameSpecial, IllegalArgumentException.class, this.fieldName()});
                }
                default: {
                    spec.addStatement("this.$N = $T.requireNonNull($N)", new Object[]{this.oneOfCase.refFieldName(), Objects.class, this.fieldName()});
                    spec.addStatement("this.$N = $T.$N", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name)});
                }
            }
        }
        builder.addMethod(spec.build());
    }

    private void addHas(TypeSpec.Builder builder) {
        if (this.kind == PropertyKind.ONE_OF_CASE) {
            return;
        }
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)fHas.apply(this.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE);
        if (this.oneOfCase == null) {
            switch (this.kind.category()) {
                case PRIMITIVE: {
                    return;
                }
                case STRING: {
                    spec.addStatement("return this.$N != null && this.$N.length()>0", new Object[]{this.fieldName(), this.fieldName()});
                    break;
                }
                case REPEATED: {
                    spec.addStatement("return this.$N != null && this.$N.size()>0", new Object[]{this.fieldName(), this.fieldName()});
                    break;
                }
                case BYTES: {
                    spec.addStatement("return this.$N != null && this.$N.length >0", new Object[]{this.fieldName(), this.fieldName()});
                    break;
                }
                case WRAPPER: 
                case MESSAGE: {
                    spec.addStatement("return this.$N != null", new Object[]{this.fieldName()});
                    break;
                }
                case ENUM: {
                    spec.addStatement("return this.$N != null && this.$N != $T.$N", new Object[]{this.fieldName(), this.fieldName(), this.typeName(), this.enumNameSpecial});
                }
            }
        } else {
            spec.addStatement("return this.$N == $T.$N", new Object[]{this.oneOfCase.fieldName(), this.oneOfCase.typeName(), this.oneOfCase.enumName(this.name)});
        }
        builder.addMethod(spec.build());
    }

    private void build(TypeSpec.Builder builder) {
        this.addField(builder);
        this.addHas(builder);
        this.addGet(builder);
        this.addSet(builder);
    }

    public static CodeBlock.Builder registryCodeBlock(TypeName typeName, TypeName protoTypeName, TypeName builderTypeName, Map<String, Property> properties) {
        CodeBlock.Builder block = CodeBlock.builder();
        ParameterizedTypeName regTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(TransFormRegistry.class), (TypeName[])new TypeName[]{typeName, protoTypeName, builderTypeName});
        block.addStatement("$T registry = new $T<>($T.class, $T::new, $T.class, $T::build, $T::newBuilder)", new Object[]{regTypeName, TransFormRegistry.class, typeName, typeName, protoTypeName, builderTypeName, protoTypeName});
        properties.values().stream().filter(p -> p.oneOfCase == null).forEach(p -> {
            block0 : switch (p.kind.category()) {
                case PRIMITIVE: {
                    block.addStatement("registry.$N($T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{p.kind.func(), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fGet), builderTypeName, p.name(fSet)});
                    break;
                }
                case WRAPPER: {
                    block.addStatement("registry.value($T.$N, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{PropertyKind.class, p.kind.name(), typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fHas), protoTypeName, p.name(fGet), builderTypeName, p.name(fSet)});
                    break;
                }
                case MESSAGE: {
                    block.addStatement("registry.value($T.class, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{p.typeName(), typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fHas), protoTypeName, p.name(fGet), builderTypeName, p.name(fSet)});
                    break;
                }
                case ENUM: {
                    if (p.kind != PropertyKind.ENUM) break;
                    block.addStatement("registry.value($T.class, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{p.typeName(), typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fGet), builderTypeName, p.name(fSet)});
                    break;
                }
                case STRING: 
                case BYTES: {
                    block.addStatement("registry.$N($T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{p.kind.func(), typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fGet), builderTypeName, p.name(fSet)});
                    break;
                }
                case REPEATED: {
                    switch (p.kind) {
                        case PRIMITIVE_LIST: 
                        case STRING_LIST: {
                            block.addStatement("registry.list($T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fList), builderTypeName, p.name(fAddAll)});
                            break block0;
                        }
                        case WRAPPER_LIST: 
                        case BYTES_LIST: {
                            block.addStatement("registry.list($T.$N, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{PropertyKind.class, p.elementKind.name(), typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fList), builderTypeName, p.name(fAddAll)});
                            break block0;
                        }
                    }
                    block.addStatement("registry.list($T.class, $T::$N, $T::$N, $T::$N, $T::$N, $T::$N)", new Object[]{p.elementTypeName, typeName, p.name(fHas), typeName, p.name(fGet), typeName, p.name(fSet), protoTypeName, p.name(fList), builderTypeName, p.name(fAddAll)});
                }
            }
        });
        for (Map.Entry<Property, List<Property>> entry : properties.values().stream().filter(p -> p.oneOfCase != null).collect(Collectors.groupingBy(p -> p.oneOfCase)).entrySet()) {
            CodeBlock.Builder code = CodeBlock.builder();
            Property oneOf = entry.getKey();
            code.add("registry.oneOf($T.class, $T::$N, $T::$N).", new Object[]{oneOf.typeName(), typeName, oneOf.name(fGet), protoTypeName, oneOf.name(fGet)}).indent();
            for (Property p2 : entry.getValue()) {
                code.add("\r\n", new Object[0]);
                switch (p2.kind.category()) {
                    case PRIMITIVE: 
                    case STRING: {
                        code.add("mapping($T.$N, $T::$N, $T::$N, $T::$N, $T::$N).", new Object[]{oneOf.typeName(), oneOf.enumName(p2.name), typeName, p2.name(fGet), typeName, p2.name(fSet), protoTypeName, p2.name(fGet), builderTypeName, p2.name(fSet)});
                        break;
                    }
                    case MESSAGE: 
                    case ENUM: {
                        code.add("mapping($T.$N, $T.class, $T::$N, $T::$N, $T::$N, $T::$N).", new Object[]{oneOf.typeName(), oneOf.enumName(p2.name), p2.typeName(), typeName, p2.name(fGet), typeName, p2.name(fSet), protoTypeName, p2.name(fGet), builderTypeName, p2.name(fSet)});
                        break;
                    }
                    case BYTES: 
                    case WRAPPER: {
                        code.add("mapping($T.$N, $T.$N, $T::$N, $T::$N, $T::$N, $T::$N).", new Object[]{oneOf.typeName(), oneOf.enumName(p2.name), PropertyKind.class, p2.kind.name(), typeName, p2.name(fGet), typeName, p2.name(fSet), protoTypeName, p2.name(fGet), builderTypeName, p2.name(fSet)});
                        break;
                    }
                }
            }
            code.add("\r\n", new Object[0]).add("build();", new Object[0]).add("\r\n", new Object[0]).unindent();
            block.add(code.build());
        }
        block.addStatement(CodeBlock.of((String)"registry.register()", (Object[])new Object[0]));
        return block;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Property) {
            Property another = (Property)object;
            return this.transform == another.transform && this.name.equals(another.name);
        }
        return false;
    }

    static void addConstructor(TypeSpec.Builder builder, Map<String, Property> properties) {
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        List props = properties.values().stream().filter(p -> p.kind != PropertyKind.ONE_OF_CASE && p.oneOfCase == null).collect(Collectors.toList());
        if (props.size() > 0) {
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            for (Property p2 : props) {
                constructor.addParameter(p2.typeName(), p2.fieldName(), new Modifier[0]);
                constructor.addStatement("this.$N = $N", new Object[]{p2.fieldName(), p2.fieldName()});
            }
            builder.addMethod(constructor.build());
        }
    }

    public static void build(TypeSpec.Builder builder, TransFormInfos transForms, Map<String, Property> properties) {
        List enumProps = properties.values().stream().filter(p -> p.kind.isEnum()).collect(Collectors.toList());
        for (Property property2 : enumProps) {
            ExecutorInfo info = property2.findExecutor(fGet);
            TransFormInfo transForm = transForms.get(info.getReturnType());
            if (transForm == null) {
                transForms.error("NEVER HAPPEN! NOT MATCH " + property2.fieldName() + "(" + property2.getKind() + ")," + info.getReturnType() + ",," + info.getName());
                return;
            }
            TypeElement typeElement = transForms.get(info.getReturnType()).getProtoElement();
            List<String> enumNames = Utils.enumNames(typeElement);
            property2.enumNameSpecial = enumNames.remove(enumNames.size() - 1);
            property2.enumNames = new HashSet<String>(enumNames);
        }
        enumProps.stream().filter(p -> p.kind == PropertyKind.ONE_OF_CASE).forEach(property -> {
            for (Map.Entry entry : properties.entrySet()) {
                Optional.ofNullable(property.enumName((String)entry.getKey())).ifPresent(p -> {
                    ((Property)entry.getValue()).oneOfCase = property;
                });
            }
        });
        properties.values().forEach(property -> property.build(builder));
    }

    private static List<Function<String, String>> nameFunctions(PropertyKind kind) {
        switch (kind) {
            case STRING: {
                return Arrays.asList(fGet, fBytes);
            }
            case MESSAGE: {
                return Arrays.asList(fGet, fHas, fOrBuilder);
            }
            case ENUM: {
                return Arrays.asList(fGet, fValue);
            }
            case STRING_LIST: {
                return Arrays.asList(fGet, fList, fCount, fBytes);
            }
            case PRIMITIVE_LIST: {
                return Arrays.asList(fGet, fList, fCount);
            }
            case ENUM_LIST: {
                return Arrays.asList(fGet, fList, fCount, fValue, fValueList);
            }
            case MESSAGE_LIST: {
                return Arrays.asList(fGet, fList, fCount, fOrBuilder, fOrBuilderList);
            }
        }
        return Collections.singletonList(fGet);
    }

    private static Optional<Property> extractByName(TransFormInfos transForms, TransFormInfo transform, Map<String, ExecutorInfo> infos, String name, PropertyKind kind) {
        List names = Property.nameFunctions(kind).stream().map(f -> (String)f.apply(name)).collect(Collectors.toList());
        if (infos.keySet().containsAll(names)) {
            List<ExecutorInfo> executors = names.stream().map(infos::remove).collect(Collectors.toList());
            switch (kind) {
                case MESSAGE: 
                case MESSAGE_LIST: 
                case PRIMITIVE_LIST: {
                    ExecutorInfo get = executors.stream().filter(e -> e.getName().equals(fGet.apply(name))).findFirst().orElseThrow(() -> new ValidationException("NEVER"));
                    if (transForms.isSameType(ByteString.class, get.getReturnType())) {
                        return Optional.of(new Property(transForms, transform, name, PropertyKind.BYTES_LIST, executors));
                    }
                    Optional<PropertyKind> wrapper = Arrays.stream(PropertyKind.values()).filter(PropertyKind::isWrapper).filter(k -> transForms.isSameType(k.rawType(), get.getReturnType())).findFirst();
                    if (!wrapper.isPresent()) break;
                    if (kind == PropertyKind.MESSAGE) {
                        return Optional.of(new Property(transForms, transform, name, wrapper.get(), executors));
                    }
                    return Optional.of(new Property(transForms, transform, name, PropertyKind.WRAPPER_LIST, executors));
                }
            }
            return Optional.of(new Property(transForms, transform, name, kind, executors));
        }
        return Optional.empty();
    }

    private static void extractByName(TransFormInfos transForms, TransFormInfo transform, Map<String, ExecutorInfo> infos, List<String> names, Map<String, Property> properties) {
        List<PropertyKind> kinds = Arrays.asList(PropertyKind.MESSAGE_LIST, PropertyKind.ENUM_LIST, PropertyKind.STRING_LIST, PropertyKind.PRIMITIVE_LIST, PropertyKind.MESSAGE, PropertyKind.ENUM, PropertyKind.STRING);
        for (PropertyKind kind : kinds) {
            for (String name : names) {
                Property.extractByName(transForms, transform, infos, name, kind).ifPresent(p -> properties.put(p.getName(), (Property)p));
            }
        }
    }

    private static Optional<Property> extractByKind(TransFormInfos transForms, TransFormInfo transform, String mname, ExecutorInfo executor) {
        if (mname.startsWith("get")) {
            String name = mname.substring(3);
            TypeKind kind = executor.getReturnKind();
            if (kind.isPrimitive()) {
                return Optional.of(new Property(transForms, transform, name, PropertyKind.valueOf((String)kind.name()), executor));
            }
            if (kind == TypeKind.DECLARED) {
                if (transForms.isByteString(executor.getReturnType())) {
                    return Optional.of(new Property(transForms, transform, name, PropertyKind.BYTES, executor));
                }
                return Optional.of(new Property(transForms, transform, name, PropertyKind.ONE_OF_CASE, executor));
            }
        }
        return Optional.empty();
    }

    public static Map<String, Property> extract(TransFormInfos transForms, TransFormInfo transform, Map<String, ExecutorInfo> infos) {
        List names = infos.keySet().stream().filter(name -> name.startsWith("get")).map(name -> name.substring(3)).collect(Collectors.toList());
        HashMap<String, Property> properties = new HashMap<String, Property>();
        List<String> sortedNames = names.stream().sorted(Comparator.comparing(String::length)).collect(Collectors.toList());
        Property.extractByName(transForms, transform, infos, sortedNames, properties);
        infos.forEach((name, executor) -> Property.extractByKind(transForms, transform, name, executor).ifPresent(p -> properties.put(p.getName(), (Property)p)));
        return names.stream().map(properties::get).filter(Objects::nonNull).collect(LinkedHashMap::new, (m, p) -> m.put(p.getName(), p), Map::putAll);
    }
}

