/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import io.grpc.stub.annotations.RpcMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jackstaff.grpc.generator.MethodInfo;
import org.jackstaff.grpc.generator.ProtocolInfo;
import org.jackstaff.grpc.generator.TransFormInfo;
import org.jackstaff.grpc.generator.TransFormInfos;

public class ProtocolProcessor
extends AbstractProcessor {
    private String getAnnotationValue(Element element, String name) {
        return element.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals(RpcMethod.class.getName())).map(this.processingEnv.getElementUtils()::getElementValuesWithDefaults).flatMap(v -> v.entrySet().stream()).filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals(name)).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(String::valueOf).findFirst().orElse("");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<ProtocolInfo> protocols = new ArrayList<ProtocolInfo>();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        LinkedHashMap<String, TypeElement> grpcs = new LinkedHashMap<String, TypeElement>();
        TransFormInfos transForms = new TransFormInfos(this.processingEnv, protocols);
        for (Element element : roundEnv.getElementsAnnotatedWith(RpcMethod.class)) {
            String fullMethodName = this.getAnnotationValue(element, "fullMethodName");
            String requestType = this.getAnnotationValue(element, "requestType");
            String responseType = this.getAnnotationValue(element, "responseType");
            String methodType = this.getAnnotationValue(element, "methodType");
            TypeElement request = this.processingEnv.getElementUtils().getTypeElement(requestType);
            TypeElement response = this.processingEnv.getElementUtils().getTypeElement(responseType);
            MethodInfo method2 = new MethodInfo(transForms, fullMethodName, methodType, request, response);
            methods.add(method2);
            grpcs.put(method2.serviceName(), (TypeElement)element.getEnclosingElement());
        }
        methods.stream().collect(Collectors.groupingBy(MethodInfo::serviceName)).forEach((name, methodInfos) -> protocols.add(new ProtocolInfo(this.processingEnv, transForms, (String)name, (TypeElement)grpcs.get(name), (List<MethodInfo>)methodInfos)));
        methods.stream().flatMap(method -> Stream.of(method.requestElement(), method.responseElement())).distinct().forEach(t -> transForms.put((TypeElement)t, new TransFormInfo(this.processingEnv, transForms, (TypeElement)t)));
        transForms.build();
        transForms.write();
        protocols.forEach(ProtocolInfo::build);
        protocols.forEach(ProtocolInfo::write);
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(RpcMethod.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

