/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.jackstaff.grpc.TransFormRegistry;
import org.jackstaff.grpc.generator.ExecutorInfo;
import org.jackstaff.grpc.generator.Property;
import org.jackstaff.grpc.generator.ProtoKind;
import org.jackstaff.grpc.generator.TransFormInfos;
import org.jackstaff.grpc.generator.Utils;

class TransFormInfo {
    private final ProcessingEnvironment processingEnv;
    private final TransFormInfos transForms;
    private final TypeElement jackstaffParent;
    private final TypeElement protoElement;
    private final ProtoKind protoKind;
    private ClassName pojoTypeName;
    private TypeSpec.Builder builder;
    private TransFormInfo parent;
    private Set<TransFormInfo> children = new HashSet<TransFormInfo>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private CodeBlock.Builder registryCodeBlock;

    public TransFormInfo(ProcessingEnvironment processingEnv, TransFormInfos transForms, TypeElement protoElement) {
        this.processingEnv = processingEnv;
        this.transForms = transForms;
        this.protoElement = protoElement;
        this.jackstaffParent = transForms.getJackstaffParent(protoElement);
        this.protoKind = transForms.getProtoType(protoElement);
    }

    public TypeName pojoTypeName() {
        return Optional.ofNullable(this.pojoTypeName).orElseGet(() -> Utils.typeName(this.protoElement));
    }

    public TypeElement getProtoElement() {
        return this.protoElement;
    }

    public ProtoKind getProtoKind() {
        return this.protoKind;
    }

    public TypeSpec getTypeSpec() {
        return Optional.ofNullable(this.builder).map(TypeSpec.Builder::build).orElse(null);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public TransFormInfo getParent() {
        return this.parent;
    }

    public void setParent(TransFormInfo parent) {
        this.parent = parent;
        if (parent != null && (this.protoKind == ProtoKind.MESSAGE || this.protoKind == ProtoKind.ENUM || this.protoKind == ProtoKind.ENUM_CASE)) {
            parent.children.add(this);
        }
    }

    public void prepare() {
        if (this.jackstaffParent == null) {
            return;
        }
        this.children.forEach(TransFormInfo::prepare);
        switch (this.protoKind) {
            case MESSAGE: {
                this.builder = TypeSpec.classBuilder((String)this.simpleName());
                TransFormInfo messageOrBuilder = this.transForms.findMessageOrBuilder(this);
                Map infos = messageOrBuilder.getProtoElement().getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(ele -> new ExecutorInfo((ExecutableElement)ele)).collect(LinkedHashMap::new, (m, e) -> m.put(e.getName(), e), HashMap::putAll);
                this.properties = Property.extract(this.transForms, this, infos);
                break;
            }
            case ENUM: 
            case ENUM_CASE: {
                this.builder = this.buildEnum();
                break;
            }
            default: {
                return;
            }
        }
        this.pojoTypeName = this.buildPojoTypeName();
        this.builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.parent != null) {
            this.builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
    }

    private ClassName buildPojoTypeName() {
        StringBuilder name = new StringBuilder(this.simpleName());
        TransFormInfo p = this.parent;
        while (p != null) {
            name.insert(0, p.simpleName() + ".");
            p = p.parent;
        }
        return ClassName.get((String)this.packageName(), (String)name.toString(), (String[])new String[0]);
    }

    private TypeSpec.Builder buildEnum() {
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)this.simpleName());
        Utils.enumNames(this.protoElement).forEach(arg_0 -> ((TypeSpec.Builder)builder).addEnumConstant(arg_0));
        MethodSpec.Builder getNumber = MethodSpec.methodBuilder((String)"getNumber").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        getNumber.addStatement("return $T.valueOf(this.name()).getNumber()", new Object[]{this.protoElement.asType()});
        builder.addMethod(getNumber.build());
        MethodSpec.Builder forNumber = MethodSpec.methodBuilder((String)"forNumber").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.simpleClassName()).addParameter(Integer.TYPE, "value", new Modifier[0]);
        forNumber.addStatement("return valueOf($T.forNumber(value).name())", new Object[]{this.protoElement.asType()});
        builder.addMethod(forNumber.build());
        this.registryCodeBlock = this.enumRegistryCode();
        return builder;
    }

    private CodeBlock.Builder enumRegistryCode() {
        CodeBlock.Builder block = CodeBlock.builder();
        ClassName typeName = this.selfClassName();
        TypeName protoTypeName = TypeName.get((TypeMirror)this.getProtoElement().asType());
        block.addStatement("$T.register($T.class, $T.class)", new Object[]{TransFormRegistry.class, typeName, protoTypeName});
        return block;
    }

    private CodeBlock.Builder messageRegistryCode() {
        TransFormInfo messageOrBuilder = this.transForms.findMessageOrBuilder(this);
        TransFormInfo messageV3Builder = this.transForms.findMessageV3Builder(messageOrBuilder);
        return Property.registryCodeBlock((TypeName)this.selfClassName(), TypeName.get((TypeMirror)this.protoElement.asType()), TypeName.get((TypeMirror)messageV3Builder.protoElement.asType()), this.properties);
    }

    Set<TransFormInfo> dependencies() {
        HashSet<TransFormInfo> set = new HashSet<TransFormInfo>();
        this.properties.values().stream().map(Property::dependency).filter(Objects::nonNull).forEach(set::add);
        this.children.stream().map(TransFormInfo::dependencies).forEach(set::addAll);
        return set;
    }

    CodeBlock.Builder getRegistryCodeBlock() {
        return this.registryCodeBlock;
    }

    TypeSpec.Builder getBuilder() {
        return this.builder;
    }

    ClassName selfClassName() {
        if (this.parent != null) {
            return this.buildPojoTypeName();
        }
        return ClassName.get((String)"", (String)this.simpleName(), (String[])new String[0]);
    }

    ClassName simpleClassName() {
        return ClassName.get((String)"", (String)this.simpleName(), (String[])new String[0]);
    }

    private String simpleName() {
        return this.protoElement.getSimpleName().toString();
    }

    String packageName() {
        return Utils.packageName(this.jackstaffParent);
    }

    Map<String, Property> getProperties() {
        return this.properties;
    }

    public void build() {
        if (this.builder == null) {
            return;
        }
        this.children.forEach(TransFormInfo::build);
        this.children.stream().map(TransFormInfo::getTypeSpec).filter(Objects::nonNull).forEach(arg_0 -> ((TypeSpec.Builder)this.builder).addType(arg_0));
        Property.build(this.builder, this.transForms, this.properties);
        if (this.protoKind == ProtoKind.MESSAGE) {
            Property.addConstructor(this.builder, this.properties);
            this.registryCodeBlock = this.messageRegistryCode();
        }
    }

    public void write() {
        if (this.parent != null || this.builder == null) {
            return;
        }
        Utils.write(this.processingEnv, this.jackstaffParent, this.builder);
    }
}

