/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolMessageEnum;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.jackstaff.grpc.TransFormRegistry;
import org.jackstaff.grpc.generator.ProtoKind;
import org.jackstaff.grpc.generator.ProtocolInfo;
import org.jackstaff.grpc.generator.RegistryMapping;
import org.jackstaff.grpc.generator.TransFormInfo;
import org.jackstaff.grpc.generator.Utils;

class TransFormInfos {
    private final ProcessingEnvironment processingEnv;
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    private final TypeElement messageV3;
    private final TypeElement messageV3Builder;
    private final TypeElement messageOrBuilder;
    private final TypeElement messageEnum;
    private final TypeElement byteString;
    private final Map<TypeElement, TransFormInfo> infos = new ConcurrentHashMap<TypeElement, TransFormInfo>();
    private final Map<TypeElement, String> parents = new ConcurrentHashMap<TypeElement, String>();
    private final Map<String, RegistryMapping> mappings = new ConcurrentHashMap<String, RegistryMapping>();
    private final List<ProtocolInfo> protocols;

    public TransFormInfos(ProcessingEnvironment processingEnv, List<ProtocolInfo> protocols) {
        this.protocols = protocols;
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.byteString = this.elements.getTypeElement(ByteString.class.getCanonicalName());
        this.messageEnum = this.elements.getTypeElement(ProtocolMessageEnum.class.getCanonicalName());
        this.messageOrBuilder = this.elements.getTypeElement(MessageOrBuilder.class.getCanonicalName());
        this.messageV3 = this.elements.getTypeElement(GeneratedMessageV3.class.getCanonicalName());
        this.messageV3Builder = this.messageV3.getEnclosedElements().stream().filter(t -> t.getKind() == ElementKind.CLASS).filter(t -> t.getSimpleName().toString().equals("Builder")).filter(t -> t instanceof TypeElement).map(t -> (TypeElement)t).findFirst().orElse(null);
    }

    public TransFormInfo get(TypeElement ele) {
        return this.infos.get(ele);
    }

    public TransFormInfo get(TypeMirror typeMirror) {
        return Optional.ofNullable((TypeElement)this.types.asElement(typeMirror)).map(this::get).orElse(null);
    }

    public void put(TypeElement ele, TransFormInfo info) {
        this.infos.put(ele, info);
    }

    private boolean isJackstaffProto(Element element) {
        String proto = this.processingEnv.getOptions().getOrDefault("JackstaffProto", "Proto");
        for (String s : proto.split(",")) {
            if (!element.toString().endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private TypeElement jackstaffProto(String name) {
        return Optional.ofNullable(name).filter(s -> s.length() > 0).map(this.elements::getTypeElement).orElse(null);
    }

    private String mappingClassName(String packageName) {
        String name = "RegistryMapping";
        if (this.elements.getTypeElement(name) == null) {
            return name;
        }
        name = "JackstaffRegistryMapping";
        while (this.elements.getTypeElement(packageName + "." + name) != null) {
            name = name + "0";
        }
        return name;
    }

    public TypeElement getJackstaffParent(TypeElement protoElement) {
        return this.jackstaffProto(this.parents.computeIfAbsent(protoElement, ele -> {
            ArrayList<Element> list = new ArrayList<Element>();
            Element parent = protoElement.getEnclosingElement();
            while (parent.getKind() == ElementKind.CLASS) {
                list.add(parent);
                parent = parent.getEnclosingElement();
            }
            Collections.reverse(list);
            return list.stream().filter(this::isJackstaffProto).findFirst().map(Object::toString).orElse("");
        }));
    }

    public void build() {
        List<TypeElement> protos = this.parents.values().stream().map(this::jackstaffProto).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        protos.forEach(p -> p.getEnclosedElements().stream().filter(e -> e instanceof TypeElement).forEach(t -> this.prepare(null, (TypeElement)t)));
        List<TransFormInfo> roots = this.infos.values().stream().filter(t -> t.getParent() == null).collect(Collectors.toList());
        roots.forEach(TransFormInfo::prepare);
        roots.forEach(TransFormInfo::build);
        Map<String, List<TransFormInfo>> packs = this.infos.values().stream().filter(info -> info.getBuilder() != null).collect(Collectors.groupingBy(TransFormInfo::packageName));
        if (!packs.isEmpty()) {
            protos.stream().map(Utils::packageName).distinct().forEach(packName -> this.mappings.put((String)packName, new RegistryMapping(this.processingEnv, this.protocols, this.mappings, (String)packName, this.mappingClassName((String)packName))));
            packs.forEach((pack, list) -> this.mappings.get(pack).build((List<TransFormInfo>)list));
        }
    }

    private void prepare(TransFormInfo parent, TypeElement element) {
        if (this.infos.containsKey(element) && this.infos.get(element).hasParent()) {
            return;
        }
        TransFormInfo info = this.infos.computeIfAbsent(element, ele -> new TransFormInfo(this.processingEnv, this, (TypeElement)ele));
        info.setParent(parent);
        element.getEnclosedElements().stream().filter(e -> e instanceof TypeElement).map(t -> (TypeElement)t).forEach(t -> this.prepare(info, (TypeElement)t));
    }

    public void write() {
        this.infos.values().forEach(TransFormInfo::write);
        this.mappings.values().forEach(RegistryMapping::write);
    }

    public TransFormInfo findMessageV3Builder(TransFormInfo messageOrBuilder) {
        for (Map.Entry<TypeElement, TransFormInfo> entry : this.infos.entrySet()) {
            TransFormInfo tf = entry.getValue();
            if (tf.getProtoKind() != ProtoKind.BUILDER || !tf.getProtoElement().getInterfaces().contains(messageOrBuilder.getProtoElement().asType())) continue;
            return tf;
        }
        return null;
    }

    public TransFormInfo findMessageOrBuilder(TransFormInfo messageV3) {
        for (Map.Entry<TypeElement, TransFormInfo> entry : this.infos.entrySet()) {
            TransFormInfo tf = entry.getValue();
            if (tf.getProtoKind() != ProtoKind.BUILDER_INTERFACE || !messageV3.getProtoElement().getInterfaces().contains(tf.getProtoElement().asType())) continue;
            return tf;
        }
        return null;
    }

    public ClassName findRegistry(String packageName) {
        return Optional.ofNullable(this.mappings.get(packageName)).filter(RegistryMapping::hasBuilder).map(RegistryMapping::selfClassName).orElseGet(() -> ClassName.get(TransFormRegistry.class));
    }

    private boolean isMessageV3(TypeElement protoElement) {
        return this.types.isSameType(protoElement.getSuperclass(), this.messageV3.asType());
    }

    private boolean isMessageV3Builder(TypeElement protoElement) {
        String s = protoElement.getSuperclass().toString();
        String v = this.messageV3Builder.toString();
        return s.startsWith(v);
    }

    private boolean isMessageOrBuilder(TypeElement protoElement) {
        List<? extends TypeMirror> intfs = protoElement.getInterfaces();
        return intfs.size() == 1 && this.types.isSameType(intfs.get(0), this.messageOrBuilder.asType());
    }

    private boolean isMessageEnum(TypeElement protoElement) {
        List<? extends TypeMirror> intfs = protoElement.getInterfaces();
        return intfs.size() == 1 && this.types.isSameType(intfs.get(0), this.messageEnum.asType());
    }

    private boolean isEnumCase(TypeElement protoElement) {
        List<? extends TypeMirror> intfs = protoElement.getInterfaces();
        return intfs.size() == 2;
    }

    public ProtoKind getProtoType(TypeElement protoElement) {
        switch (protoElement.getKind()) {
            case CLASS: {
                if (this.isMessageV3(protoElement)) {
                    return ProtoKind.MESSAGE;
                }
                if (!this.isMessageV3Builder(protoElement)) break;
                return ProtoKind.BUILDER;
            }
            case INTERFACE: {
                if (!this.isMessageOrBuilder(protoElement)) break;
                return ProtoKind.BUILDER_INTERFACE;
            }
            case ENUM: {
                if (this.isMessageEnum(protoElement)) {
                    return ProtoKind.ENUM;
                }
                if (!this.isEnumCase(protoElement)) break;
                return ProtoKind.ENUM_CASE;
            }
        }
        return ProtoKind.OTHER;
    }

    public boolean isSameType(Class<?> type, TypeMirror typeMirror) {
        return this.types.isSameType(typeMirror, this.elements.getTypeElement(type.getCanonicalName()).asType());
    }

    public boolean isByteString(TypeMirror type) {
        return this.types.isSameType(type, this.byteString.asType());
    }

    public void warning(String message) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, message);
    }

    public void error(String message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message);
    }
}

