/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.squareup.javapoet.TypeName;
import io.grpc.MethodDescriptor;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import org.jackstaff.grpc.generator.TransFormInfos;
import org.jackstaff.grpc.generator.Utils;

class MethodInfo {
    private final TransFormInfos transForms;
    private final String serviceName;
    private final String methodName;
    private final TypeElement requestElement;
    private final TypeElement responseElement;
    private final MethodDescriptor.MethodType methodType;

    public MethodInfo(TransFormInfos transForms, String fullMethodName, String methodType, TypeElement requestElement, TypeElement responseElement) {
        this.transForms = transForms;
        this.methodType = MethodDescriptor.MethodType.valueOf((String)methodType);
        this.requestElement = requestElement;
        this.responseElement = responseElement;
        this.serviceName = Optional.ofNullable(MethodDescriptor.extractFullServiceName((String)fullMethodName)).orElse("");
        this.methodName = Utils.lowerCamelName(fullMethodName.substring(this.serviceName.length() + 1));
    }

    public String serviceName() {
        return this.serviceName;
    }

    public TypeElement requestElement() {
        return this.requestElement;
    }

    public TypeElement responseElement() {
        return this.responseElement;
    }

    public TypeName request() {
        return this.transForms.get(this.requestElement).pojoTypeName();
    }

    public TypeName response() {
        return this.transForms.get(this.responseElement).pojoTypeName();
    }

    public MethodDescriptor.MethodType getMethodType() {
        return this.methodType;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

