/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.grpc.ServiceDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import org.jackstaff.grpc.TransFormRegistry;
import org.jackstaff.grpc.generator.Property;
import org.jackstaff.grpc.generator.ProtoKind;
import org.jackstaff.grpc.generator.ProtocolInfo;
import org.jackstaff.grpc.generator.TransFormInfo;
import org.jackstaff.grpc.generator.Utils;
import org.jackstaff.grpc.internal.PropertyKind;

class RegistryMapping {
    static final String SIMPLE_CLASS_NAME = "RegistryMapping";
    private final ProcessingEnvironment processingEnv;
    private final List<ProtocolInfo> protocols;
    private final Map<String, RegistryMapping> mappings;
    private final String packageName;
    private final String simpleName;
    private TypeSpec.Builder builder;

    public RegistryMapping(ProcessingEnvironment processingEnv, List<ProtocolInfo> protocols, Map<String, RegistryMapping> mappings, String packageName, String simpleName) {
        this.processingEnv = processingEnv;
        this.protocols = protocols;
        this.mappings = mappings;
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassName selfClassName() {
        return ClassName.get((String)this.packageName, (String)this.simpleName, (String[])new String[0]);
    }

    public boolean hasBuilder() {
        return this.builder != null;
    }

    public TypeSpec.Builder getBuilder() {
        return this.builder;
    }

    public void write() {
        if (this.builder != null) {
            Utils.write(this.processingEnv, this.packageName, this.builder);
        }
    }

    private void addDependencies(List<TransFormInfo> infos) {
        HashSet<TransFormInfo> set = new HashSet<TransFormInfo>(infos);
        this.protocols.stream().filter(p -> p.packageName().equals(this.packageName)).map(ProtocolInfo::dependencies).flatMap(Collection::stream).forEach(set::add);
        Set packs = set.stream().map(TransFormInfo::packageName).collect(Collectors.toSet());
        set.stream().flatMap(info -> info.dependencies().stream()).map(TransFormInfo::packageName).forEach(packs::add);
        List<String> names = packs.stream().filter(pack -> !pack.equals(this.packageName)).map(this.mappings::get).filter(Objects::nonNull).map(r -> r.selfClassName().canonicalName()).collect(Collectors.toList());
        if (!names.isEmpty()) {
            CodeBlock.Builder block = CodeBlock.builder();
            names.forEach(name -> block.addStatement("$T.dependency($S)", new Object[]{TransFormRegistry.class, name}));
            this.builder.addStaticBlock(block.build());
        }
    }

    public void build(List<TransFormInfo> infos) {
        this.builder = TypeSpec.classBuilder((ClassName)this.selfClassName());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"addProtocol").addModifiers(new Modifier[]{Modifier.STATIC}).returns(String.class).addParameter(ParameterizedTypeName.get(Class.class), "protocol", new Modifier[0]).addParameter(ServiceDescriptor.class, "descriptor", new Modifier[0]).addStatement("return $T.addProtocol(protocol, descriptor)", new Object[]{TransFormRegistry.class});
        this.builder.addMethod(spec.build());
        this.addDependencies(infos);
        infos.stream().sorted((info1, info2) -> {
            if (info1.getProtoKind() == info2.getProtoKind() && info1.getProtoKind() == ProtoKind.MESSAGE) {
                Set deps2;
                List props1 = info1.getProperties().values().stream().filter(p -> p.getKind() == PropertyKind.MESSAGE || p.getKind() == PropertyKind.MESSAGE_LIST).collect(Collectors.toList());
                List props2 = info2.getProperties().values().stream().filter(p -> p.getKind() == PropertyKind.MESSAGE || p.getKind() == PropertyKind.MESSAGE_LIST).collect(Collectors.toList());
                if (props1.isEmpty() && props2.isEmpty()) {
                    return info1.getProperties().size() - info2.getProperties().size();
                }
                Set deps1 = props1.stream().map(Property::dependency).filter(Objects::nonNull).collect(Collectors.toSet());
                if (deps1.containsAll(deps2 = props2.stream().map(Property::dependency).filter(Objects::nonNull).collect(Collectors.toSet()))) {
                    return 1;
                }
                if (deps2.containsAll(deps1)) {
                    return -1;
                }
                long count1 = deps1.stream().filter(deps2::contains).count();
                long count2 = deps2.stream().filter(deps1::contains).count();
                if (count1 > 0L || count2 > 0L) {
                    if (count1 == 0L || count2 == 0L) {
                        return (int)(count2 - count1);
                    }
                    if (info1.getProtoElement().toString().startsWith(info2.getProtoElement().toString() + ".")) {
                        return -1;
                    }
                    if (info2.getProtoElement().toString().startsWith(info1.getProtoElement().toString() + ".")) {
                        return 1;
                    }
                    return (int)(count2 - count1);
                }
                if (props1.size() == props2.size()) {
                    return info2.getProtoElement().toString().length() - info1.getProtoElement().toString().length();
                }
                return props1.size() - props2.size();
            }
            return info1.getProtoKind().ordinal() - info2.getProtoKind().ordinal();
        }).map(TransFormInfo::getRegistryCodeBlock).filter(Objects::nonNull).forEach(block -> this.builder.addStaticBlock(block.build()));
    }
}

