/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.generator;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.jackstaff.grpc.generator.MethodInfo;

class Utils {
    Utils() {
    }

    public static String packageName(TypeElement typeElement) {
        return typeElement.getEnclosingElement() + "";
    }

    public static void write(ProcessingEnvironment env, TypeElement packRef, TypeSpec.Builder builder) {
        Utils.write(env, Utils.packageName(packRef), builder);
    }

    public static void write(ProcessingEnvironment env, String packageName, TypeSpec.Builder builder) {
        builder.addJavadoc("Generated by org.jackstaff.grpc.generator.ProtocolProcessor;  DO NOT EDIT!", new Object[0]);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)builder.build()).skipJavaLangImports(true).indent("    ").build();
        try {
            javaFile.writeTo(env.getFiler());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static ParameterSpec parameter(Element el) {
        return Utils.parameter(Utils.typeName(el));
    }

    public static ParameterSpec parameter(TypeName tn) {
        return ParameterSpec.builder((TypeName)tn, (String)Utils.lowerCamelName(tn), (Modifier[])new Modifier[0]).build();
    }

    public static ParameterSpec responseParameter(MethodInfo method) {
        String suffix;
        switch (method.getMethodType()) {
            case UNARY: 
            case CLIENT_STREAMING: {
                suffix = "Result";
                break;
            }
            default: {
                suffix = "Stream";
            }
        }
        switch (method.getMethodType()) {
            case CLIENT_STREAMING: 
            case BIDI_STREAMING: {
                return Utils.streamingParameter(method.response(), suffix);
            }
        }
        if (method.request().toString().endsWith(suffix)) {
            return Utils.streamingParameter(method.response(), "Consumer");
        }
        return Utils.streamingParameter(method.response(), suffix);
    }

    private static ParameterSpec streamingParameter(TypeName tn, String suffix) {
        return ParameterSpec.builder((TypeName)Utils.consumerTypeName(tn), (String)(Utils.lowerCamelName(tn) + suffix), (Modifier[])new Modifier[0]).build();
    }

    public static TypeName typeName(Element el) {
        return TypeName.get((TypeMirror)el.asType());
    }

    public static TypeName consumerTypeName(TypeName tn) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{tn});
    }

    public static TypeName listTypeName(TypeName tn) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{tn});
    }

    public static String lowerCamelName(TypeName tn) {
        if (tn instanceof ClassName) {
            return Utils.lowerCamelName(((ClassName)tn).simpleName());
        }
        return Utils.lowerCamelName(tn.toString());
    }

    public static String lowerCamelName(String name) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name.indexOf(".") > 0 ? name.substring(name.lastIndexOf(".") + 1) : name);
    }

    public static List<String> enumNames(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(ele -> ele.getKind() == ElementKind.ENUM_CONSTANT).map(Object::toString).collect(Collectors.toList());
    }
}

