/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.configuration;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jackstaff.grpc.Client;
import org.jackstaff.grpc.Interceptor;
import org.jackstaff.grpc.Server;
import org.jackstaff.grpc.configuration.Configuration;
import org.jackstaff.grpc.exception.ValidationException;
import org.springframework.cglib.proxy.Proxy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

public class SpringConfiguration {
    private static final Map<Class<? extends Interceptor>, Interceptor> interceptors = new ConcurrentHashMap<Class<? extends Interceptor>, Interceptor>();
    private final ApplicationContext appContext;
    private final Configuration configuration;

    public SpringConfiguration(ApplicationContext appContext, Configuration configuration) {
        this.appContext = appContext;
        this.configuration = configuration;
    }

    public static Interceptor getInterceptor(Class<? extends Interceptor> clazz) {
        return interceptors.computeIfAbsent(clazz, c -> {
            try {
                return (Interceptor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new ValidationException(clazz + " can't newInstance", (Throwable)ex);
            }
        });
    }

    public static List<Interceptor> getInterceptors(Class<? extends Interceptor>[] types) {
        return Arrays.stream(types).map(SpringConfiguration::getInterceptor).collect(Collectors.toList());
    }

    public Server newServer() {
        Server server = new Server();
        Optional.ofNullable(this.configuration.getServer()).ifPresent(cfg -> {
            this.appContext.getBeansWithAnnotation(org.jackstaff.grpc.annotation.Server.class).values().forEach(bean -> {
                org.jackstaff.grpc.annotation.Server s = bean.getClass().getAnnotation(org.jackstaff.grpc.annotation.Server.class);
                Class[] services = Optional.of(s.service()).filter(a -> ((Class[])a).length > 0).orElseGet(s::value);
                if (services.length == 0) {
                    throw new ValidationException(bean.getClass().getName() + "@Server service is empty");
                }
                Arrays.stream(services).forEach(type -> server.register(type, bean, SpringConfiguration.getInterceptors(s.interceptor())));
            });
            server.start(cfg);
            if (this.appContext instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)this.appContext;
                ctx.addApplicationListener(evt -> server.shutdown());
            }
        });
        return server;
    }

    public Client newClient() {
        Client client = new Client((type, handler) -> Proxy.newProxyInstance((ClassLoader)type.getClassLoader(), (Class[])new Class[]{type}, handler::invoke));
        Optional.ofNullable(this.configuration.getClient()).ifPresent(arg_0 -> ((Client)client).setup(arg_0));
        this.appContext.getBeansWithAnnotation(Component.class).forEach((name, bean) -> this.inject(client, (String)name, bean));
        if (this.appContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)this.appContext;
            ctx.addApplicationListener(evt -> client.shutdown());
        }
        return client;
    }

    private void inject(Client theClient, String name, Object bean) {
        Map<Field, org.jackstaff.grpc.annotation.Client> fields = this.clientFields(bean);
        fields.forEach((field, client) -> this.inject(theClient, name, bean, (Field)field, (org.jackstaff.grpc.annotation.Client)client));
    }

    private Map<Field, org.jackstaff.grpc.annotation.Client> clientFields(Object bean) {
        HashMap<Field, org.jackstaff.grpc.annotation.Client> fields = new HashMap<Field, org.jackstaff.grpc.annotation.Client>();
        Class<?> clz = bean.getClass();
        while (!clz.equals(Object.class)) {
            Arrays.stream(clz.getDeclaredFields()).forEach(field -> Optional.ofNullable(field.getAnnotation(org.jackstaff.grpc.annotation.Client.class)).ifPresent(client -> fields.put((Field)field, (org.jackstaff.grpc.annotation.Client)client)));
            clz = clz.getSuperclass();
        }
        return fields;
    }

    private void inject(Client theClient, String name, Object bean, Field field, org.jackstaff.grpc.annotation.Client client) {
        String authority = Optional.of(client.authority()).filter(a -> !a.isEmpty()).orElseGet(client::value);
        if (authority.isEmpty()) {
            throw new ValidationException(name + ":" + field.getName() + "@Client value/authority is empty");
        }
        if (!field.getType().isInterface()) {
            throw new ValidationException(name + ":" + field.getName() + "@Client field MUST be interface");
        }
        field.setAccessible(true);
        try {
            if (field.get(bean) == null) {
                Object value = theClient.autowired(authority, field.getType(), client.required(), SpringConfiguration.getInterceptors(client.interceptor()));
                field.set(bean, value);
            }
        }
        catch (Throwable ex) {
            throw new ValidationException(name + ":" + field.getName() + "@Client autowired fail", ex);
        }
    }
}

