/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageProducer;
import org.jacorb.demo.notification.whiteboard.WorkgroupController;

public class BrushSizeDrawCanvas
extends Canvas {
    WorkgroupController controller_;
    ImageProducer imageProducer_;
    private int lastX;
    private int lastY;
    private int drawRed = 255;
    private int drawGreen = 255;
    private int drawBlue = 255;

    public BrushSizeDrawCanvas(WorkgroupController controller, int width, int height) {
        this.setSize(width, height);
        this.controller_ = controller;
        this.initialize();
    }

    public void initialize() {
        this.imageProducer_ = this.controller_.getImage().getProducer();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BrushSizeDrawCanvas.this.lastX = e.getX();
                BrushSizeDrawCanvas.this.lastY = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                BrushSizeDrawCanvas.this.controller_.drawLine(BrushSizeDrawCanvas.this.lastX, BrushSizeDrawCanvas.this.lastY, e.getX(), e.getY(), BrushSizeDrawCanvas.this.drawRed, BrushSizeDrawCanvas.this.drawGreen, BrushSizeDrawCanvas.this.drawBlue);
                BrushSizeDrawCanvas.this.lastX = e.getX();
                BrushSizeDrawCanvas.this.lastY = e.getY();
                BrushSizeDrawCanvas.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.createImage(this.imageProducer_), 0, 0, null);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void setDrawColor(int red, int green, int blue) {
        this.drawRed = red;
        this.drawGreen = green;
        this.drawBlue = blue;
    }

    public void clearAll() {
        this.controller_.clearAll();
        this.repaint();
    }

    void setBrushSize(int size) {
        this.controller_.setBrushSize(size);
    }
}

