/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.awt.Color;
import org.jacorb.demo.notification.whiteboard.PixelImage;

public class BrushSizePixelImage
extends PixelImage {
    int brushSize = 1;
    boolean brush = true;
    int width;
    int height;

    public void setBrushSize(int x) {
        this.brushSize = x;
    }

    public int getBrushSize() {
        return this.brushSize;
    }

    public BrushSizePixelImage(int width, int height) {
        super(width, height);
        this.width = width;
        this.height = height;
    }

    public void setArea(int x, int y, int r, int g, int b) {
        for (int xi = x - this.brushSize; xi <= x + this.brushSize; ++xi) {
            for (int yi = y - this.brushSize; yi <= y + this.brushSize; ++yi) {
                if (xi < 0 || yi < 0 || xi >= this.width || yi >= this.height) continue;
                super.setPixel(xi, yi, r, g, b);
            }
        }
    }

    @Override
    public void setPixel(int x, int y, int red, int green, int blue) {
        Color color = new Color(red, green, blue);
        if (this.brush) {
            this.setArea(x, y, red, green, blue);
        } else {
            super.setPixel(x, y, red, green, blue);
        }
    }

    @Override
    public void clearAll() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                super.setPixel(x, y, 0, 0, 0);
            }
        }
    }
}

