/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.awt.Color;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;

public class PixelImage {
    private static final int ALPHA = -16777216;
    protected int[] m_pixels;
    private int width;
    private int height;

    public PixelImage(int width, int height) {
        this.m_pixels = new int[width * height];
        this.width = width;
        this.height = height;
        this.clearAll();
    }

    public void setPixel(int x, int y, int red, int green, int blue) {
        this.m_pixels[this.width * y + x] = 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public void setPixel(int x, int y, Color color) {
        this.m_pixels[this.width * y + x] = color.getRGB();
    }

    public ImageProducer getProducer() {
        return new MemoryImageSource(this.width, this.height, this.m_pixels, 0, this.width);
    }

    public int[] getPixelBuffer() {
        return this.m_pixels;
    }

    public void setPixelBuffer(int[] data) {
        this.m_pixels = data;
    }

    public void drawLine(int x0, int y0, int x1, int y1, int red, int green, int blue) {
        if (x0 < 0 || x1 < 0 || y1 < 0 || y0 < 0 || x0 >= this.width || x1 >= this.width || y0 >= this.height || y1 >= this.height) {
            return;
        }
        if (x0 == x1 && y0 == y1) {
            this.setPixel(x0, y0, red, green, blue);
        } else {
            float grad = (float)(y1 - y0) / (float)(x1 - x0);
            if ((double)grad >= -1.0 && (double)grad <= 1.0) {
                if (x0 > x1) {
                    int change = x1;
                    x1 = x0;
                    x0 = change;
                    change = y1;
                    y1 = y0;
                    y0 = change;
                }
                float y = y0;
                while (x0 <= x1) {
                    this.setPixel(x0, (int)((double)y + 0.5), red, green, blue);
                    y += grad;
                    ++x0;
                }
            } else {
                grad = 1.0f / grad;
                if (y0 > y1) {
                    int change = x1;
                    x1 = x0;
                    x0 = change;
                    change = y1;
                    y1 = y0;
                    y0 = change;
                }
                float x = x0;
                while (y0 <= y1) {
                    this.setPixel((int)((double)x + 0.5), y0, red, green, blue);
                    ++y0;
                    x += grad;
                }
            }
        }
    }

    public void clearAll() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setPixel(x, y, 0, 0, 0);
            }
        }
    }
}

