/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.util.Hashtable;
import java.util.Map;
import org.jacorb.demo.notification.whiteboard.BrushSizePixelImage;
import org.jacorb.demo.notification.whiteboard.Dispatcher;
import org.jacorb.demo.notification.whiteboard.ExtendedPixelImage;
import org.jacorb.demo.notification.whiteboard.IRegistrationInfo;
import org.jacorb.demo.notification.whiteboard.IWhiteBoardOperations;
import org.jacorb.demo.notification.whiteboard.IWhiteBoardPOA;
import org.jacorb.demo.notification.whiteboard.IWorkgroup;
import org.jacorb.demo.notification.whiteboard.LocalRegistrationInfo;
import org.jacorb.demo.notification.whiteboard.WhiteboardVars;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidGrammar;

public class WhiteBoard
extends IWhiteBoardPOA
implements IWhiteBoardOperations,
WhiteboardVars {
    static int COUNT = 0;
    EventChannel channel_;
    FilterFactory filterFactory_;
    protected Map workgroups_;
    Map registrationInfo_ = new Hashtable();
    Dispatcher disp;
    BrushSizePixelImage image;

    public WhiteBoard(ORB orb, EventChannel channel) throws AdminLimitExceeded {
        this(orb, channel, 400, 400);
    }

    public WhiteBoard(ORB orb, EventChannel channel, int xsize, int ysize) throws AdminLimitExceeded {
        System.out.println("WhiteBoard.init()");
        this._this(orb);
        this.workgroups_ = new Hashtable();
        this.clear();
        this.image = new ExtendedPixelImage(xsize, ysize);
        this.disp = new Dispatcher(orb, this, channel.default_supplier_admin());
        System.out.println("done");
        this.filterFactory_ = channel.default_filter_factory();
        this.channel_ = channel;
    }

    public int[] getCurrentImage() {
        return this.image.getPixelBuffer();
    }

    @Override
    public IRegistrationInfo join(IWorkgroup group) {
        System.out.println("Workgroup joins the Whiteboard ");
        Integer _id = new Integer(COUNT++);
        System.out.println("workgroups: " + this.workgroups_ + ".put(" + _id + ", " + group);
        this.workgroups_.put(_id, group);
        IRegistrationInfo _registrationInfo = new IRegistrationInfo();
        _registrationInfo.workgroup_identifier = _id;
        IntHolder _supplierAdminId = new IntHolder();
        IntHolder _consumerAdminId = new IntHolder();
        Filter _filter = null;
        try {
            _filter = this.filterFactory_.create_filter("EXTENDED_TCL");
            ConstraintExp[] _constraints = new ConstraintExp[]{new ConstraintExp()};
            _constraints[0].event_types = new EventType[]{new EventType("NOTIFICATION DEMO", "*")};
            _constraints[0].constraint_expr = "$.header.variable_header(workgroup_id) != " + _id;
            _filter.add_constraints(_constraints);
            SupplierAdmin _supplierAdmin = this.channel_.new_for_suppliers(InterFilterGroupOperator.AND_OP, _supplierAdminId);
            ConsumerAdmin _consumerAdmin = this.channel_.new_for_consumers(InterFilterGroupOperator.AND_OP, _consumerAdminId);
            _consumerAdmin.add_filter(_filter);
            _registrationInfo.supplier_admin = _supplierAdmin;
            _registrationInfo.consumer_admin = _consumerAdmin;
            _registrationInfo.filter_factory = this.filterFactory_;
            LocalRegistrationInfo _localInfo = new LocalRegistrationInfo();
            _localInfo.consumerAdmin_ = _consumerAdminId.value;
            _localInfo.supplierAdmin_ = _supplierAdminId.value;
            this.registrationInfo_.put(_id, _localInfo);
            return _registrationInfo;
        }
        catch (InvalidGrammar ig) {
            ig.printStackTrace();
        }
        catch (InvalidConstraint ic) {
            ic.printStackTrace();
        }
        throw new RuntimeException();
    }

    @Override
    public boolean leave(int workgroup) {
        System.out.println("Bye");
        Integer _id = new Integer(workgroup);
        LocalRegistrationInfo _info = (LocalRegistrationInfo)this.registrationInfo_.get(_id);
        try {
            this.channel_.get_consumeradmin(_info.consumerAdmin_).destroy();
            this.channel_.get_supplieradmin(_info.supplierAdmin_).destroy();
        }
        catch (AdminNotFound anf) {
            // empty catch block
        }
        return this.workgroups_.remove(_id) != null;
    }

    public void clear() {
    }
}

