/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jacorb.demo.notification.whiteboard.WorkgroupController;

public class SelectDialog
extends Dialog {
    private Panel panel1;
    private Button joinButton;
    private Button refreshButton;
    private List availableList;
    private TextField selectionTField;
    private WorkgroupController controller_;

    public SelectDialog(Frame parentFrame, WorkgroupController controller) {
        super(parentFrame, "Select a Whiteboard");
        this.initComponents();
        this.controller_ = controller;
        this.pack();
        this.refresh();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SelectDialog.this.closeDialog(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.panel1 = new Panel();
        this.panel1.setName("buttonPanel");
        this.panel1.setLayout(new FlowLayout());
        this.joinButton = new Button();
        this.joinButton.setLabel("Join");
        this.joinButton.setName("joinButton");
        this.joinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectDialog.this.joinButtonActionPerformed(evt);
            }
        });
        this.panel1.add(this.joinButton);
        this.refreshButton = new Button();
        this.refreshButton.setLabel("Refresh");
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectDialog.this.refreshButtonActionPerformed(evt);
            }
        });
        this.panel1.add(this.refreshButton);
        this.add((Component)this.panel1, "South");
        this.availableList = new List();
        this.availableList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDialog.this.selectionTField.setText(SelectDialog.this.availableList.getSelectedItem());
            }
        });
        this.availableList.setName("availableList");
        this.add((Component)this.availableList, "Center");
        this.selectionTField = new TextField();
        this.add((Component)this.selectionTField, "North");
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void joinButtonActionPerformed(ActionEvent evt) {
        String result = this.selectionTField.getText();
        if (result.length() > 0) {
            this.controller_.selectWhiteboard(result);
            this.close();
        }
    }

    void refresh() {
        this.availableList.removeAll();
        String[] _list = this.controller_.getListOfWhiteboards();
        for (int x = 0; x < _list.length; ++x) {
            this.availableList.add(_list[x]);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.close();
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }
}

