/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import org.jacorb.demo.notification.whiteboard.BrushSizePixelImage;
import org.jacorb.demo.notification.whiteboard.ClearHandler;
import org.jacorb.demo.notification.whiteboard.IFactory;
import org.jacorb.demo.notification.whiteboard.IFactoryHelper;
import org.jacorb.demo.notification.whiteboard.IRegistrationInfo;
import org.jacorb.demo.notification.whiteboard.IWhiteBoard;
import org.jacorb.demo.notification.whiteboard.IWorkgroupPOA;
import org.jacorb.demo.notification.whiteboard.ImageHandler;
import org.jacorb.demo.notification.whiteboard.LineHandler;
import org.jacorb.demo.notification.whiteboard.PixelImage;
import org.jacorb.demo.notification.whiteboard.TotalImageHandler;
import org.jacorb.demo.notification.whiteboard.WhiteboardVars;
import org.jacorb.demo.notification.whiteboard.WorkgroupController;
import org.jacorb.demo.notification.whiteboard.WorkgroupFrame;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumerHelper;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class Workgroup
extends IWorkgroupPOA
implements WorkgroupController,
WhiteboardVars {
    protected ORB orb_;
    protected POA poa_;
    protected WorkgroupFrame workgroupFrame_;
    protected BrushSizePixelImage image_;
    protected int myId;
    protected IWhiteBoard whiteboard_;
    protected IFactory factory_;
    TotalImageHandler totalImageHandler_;
    LineHandler lineHandler_;
    ClearHandler clearHandler_;
    ImageHandler imageHandler_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TotalImageHandler getTotalImageHandler() {
        if (this.totalImageHandler_ == null) {
            Workgroup workgroup = this;
            synchronized (workgroup) {
                if (this.totalImageHandler_ == null) {
                    this.totalImageHandler_ = new TotalImageHandler(this);
                }
            }
        }
        return this.totalImageHandler_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineHandler getLineHandler() {
        if (this.lineHandler_ == null) {
            Workgroup workgroup = this;
            synchronized (workgroup) {
                if (this.lineHandler_ == null) {
                    this.lineHandler_ = new LineHandler(this);
                }
            }
        }
        return this.lineHandler_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClearHandler getClearHandler() {
        if (this.clearHandler_ == null) {
            Workgroup workgroup = this;
            synchronized (workgroup) {
                if (this.clearHandler_ == null) {
                    this.clearHandler_ = new ClearHandler(this);
                }
            }
        }
        return this.clearHandler_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImageHandler getImageHandler() {
        if (this.imageHandler_ == null) {
            Workgroup workgroup = this;
            synchronized (workgroup) {
                if (this.imageHandler_ == null) {
                    this.imageHandler_ = new ImageHandler(this);
                }
            }
        }
        return this.imageHandler_;
    }

    public Workgroup(ORB orb, POA poa, IFactory factory) {
        this.orb_ = orb;
        this.poa_ = poa;
        this._this(orb);
        this.factory_ = factory;
        this.image_ = new BrushSizePixelImage(400, 400);
        this.workgroupFrame_ = new WorkgroupFrame(this, "Whiteboard");
        this.clearAll();
    }

    @Override
    public String[] getListOfWhiteboards() {
        return this.factory_.listAllWhiteboards();
    }

    @Override
    public void selectWhiteboard(String name) {
        this.whiteboard_ = this.factory_.getCreateWhiteboard(name);
        IRegistrationInfo _info = this.whiteboard_.join(this._this(this.orb_));
        this.myId = _info.workgroup_identifier;
        IntHolder imageListenerId_ = new IntHolder();
        try {
            StructuredProxyPushConsumer _consumer = StructuredProxyPushConsumerHelper.narrow((Object)_info.supplier_admin.obtain_notification_push_consumer(ClientType.STRUCTURED_EVENT, imageListenerId_));
            this.imageHandler_ = this.getImageHandler();
            this.imageHandler_.connect(_consumer);
            this.lineHandler_ = this.getLineHandler();
            this.lineHandler_.connect(StructuredProxyPushSupplierHelper.narrow((Object)_info.consumer_admin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, imageListenerId_)), _info.filter_factory);
            this.clearHandler_ = this.getClearHandler();
            this.clearHandler_.connect(StructuredProxyPushSupplierHelper.narrow((Object)_info.consumer_admin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, imageListenerId_)), _info.filter_factory);
            this.workgroupFrame_.setCurrentBoardText(name);
            this.workgroupFrame_.setLeaveMenuItem(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.workgroupFrame_.repaint();
    }

    @Override
    public void leaveWhiteboard() {
        this.imageHandler_.shutdown();
        this.lineHandler_.shutdown();
        this.clearHandler_.shutdown();
        this.imageHandler_ = null;
        this.lineHandler_ = null;
        this.clearHandler_ = null;
        this.whiteboard_.leave(this.myId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit() {
        try {
            this.leaveWhiteboard();
        }
        finally {
            System.exit(0);
        }
    }

    @Override
    public int getWorkgroupId() {
        return this.myId;
    }

    @Override
    public void drawLine(int x0, int y0, int x1, int y1, int red, int green, int blue) {
        this.image_.drawLine(x0, y0, x1, y1, red, green, blue);
        if (this.imageHandler_ != null) {
            this.imageHandler_.drawLine(x0, y0, x1, y1, red, green, blue, this.image_.getBrushSize());
        }
    }

    @Override
    public void drawLineLocal(int x0, int y0, int x1, int y1, int red, int green, int blue, int brushsize) {
        int _savedBrushsize = this.image_.getBrushSize();
        this.image_.setBrushSize(brushsize);
        this.image_.drawLine(x0, y0, x1, y1, red, green, blue);
        this.image_.setBrushSize(_savedBrushsize);
        this.workgroupFrame_.getDrawCanvas().repaint();
    }

    @Override
    public PixelImage getImage() {
        return this.image_;
    }

    @Override
    public void clearAll() {
        if (this.imageHandler_ != null) {
            this.imageHandler_.clear();
        }
        this.clearAllLocal();
    }

    @Override
    public void clearAllLocal() {
        this.image_.clearAll();
        this.workgroupFrame_.getDrawCanvas().repaint();
    }

    @Override
    public void setBrushSize(int i) {
        this.image_.setBrushSize(i);
    }

    @Override
    public ORB getOrb() {
        return this.orb_;
    }

    @Override
    public void updateWholeImage(int[] data) {
        this.image_.setPixelBuffer(data);
        this.workgroupFrame_.getDrawCanvas().repaint();
        try {
            this.totalImageHandler_.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.totalImageHandler_ = null;
        }
    }

    public static void main(String[] args) {
        ORB _orb = ORB.init((String[])args, null);
        try {
            POA _poa = POAHelper.narrow((Object)_orb.resolve_initial_references("RootPOA"));
            NamingContext nc = NamingContextHelper.narrow((Object)_orb.resolve_initial_references("NameService"));
            NameComponent[] name = new NameComponent[]{new NameComponent("WhiteBoard", "Factory")};
            IFactory _factory = IFactoryHelper.narrow(nc.resolve(name));
            Workgroup wg = new Workgroup(_orb, _poa, _factory);
            _poa.the_POAManager().activate();
            wg.workgroupFrame_.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

