/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.util.Iterator;
import java.util.List;
import org.jacorb.demo.notification.whiteboard.BrushSizePixelImage;
import org.jacorb.demo.notification.whiteboard.LineData;
import org.jacorb.demo.notification.whiteboard.UpdateLine;
import org.jacorb.demo.notification.whiteboard.WhiteboardUpdate;
import org.jacorb.demo.notification.whiteboard.WhiteboardUpdateHelper;
import org.jacorb.demo.notification.whiteboard.WhiteboardVars;
import org.omg.CORBA.ORB;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumer;

public class ExtendedPixelImage
extends BrushSizePixelImage
implements WhiteboardVars {
    StructuredProxyPushConsumer myConsumer_;
    StructuredEvent event_;
    ORB orb_;

    public void setPixels(int[] pixels) {
        for (int x = 0; x < this.m_pixels.length; ++x) {
            this.m_pixels[x] = pixels[x];
        }
    }

    public ExtendedPixelImage(int w, int h) {
        super(w, h);
    }

    public void setOrb(ORB orb) {
        this.orb_ = orb;
    }

    public void setEvent(StructuredEvent event) {
        this.event_ = event;
    }

    @Override
    public synchronized void clearAll() {
        WhiteboardUpdate _update = new WhiteboardUpdate();
        _update.clear(true);
        super.clearAll();
    }

    public void localClearAll() {
        super.clearAll();
    }

    public synchronized void drawLine(int x0, int y0, int x1, int y1, int red, int green, int blue, int brushSize) {
        int x = this.getBrushSize();
        this.setBrushSize(brushSize);
        super.drawLine(x0, y0, x1, y1, red, green, blue);
        this.setBrushSize(x);
    }

    @Override
    public synchronized void drawLine(int x0, int y0, int x1, int y1, int red, int green, int blue) {
        WhiteboardUpdate _update = new WhiteboardUpdate();
        super.drawLine(x0, y0, x1, y1, red, green, blue);
        _update.line(new LineData(x0, y0, x1, y1, red, green, blue, this.getBrushSize()));
        try {
            if (this.myConsumer_ != null) {
                WhiteboardUpdateHelper.insert(this.event_.remainder_of_body, _update);
                this.myConsumer_.push_structured_event(this.event_);
            }
        }
        catch (Disconnected d) {
            d.printStackTrace();
            this.myConsumer_ = null;
        }
    }

    public synchronized void drawLine(UpdateLine ul, boolean v) {
        this.drawLine(ul);
    }

    void drawLine(UpdateLine ul) {
        if (!ul.clearScreen()) {
            this.drawLine(ul.getX0(), ul.getY0(), ul.getX1(), ul.getY1(), ul.getRed(), ul.getGreen(), ul.getBlue(), ul.getBrushSize());
        } else {
            super.clearAll();
        }
    }

    public void drawLine(List uls) {
        Iterator i = uls.iterator();
        while (i.hasNext()) {
            this.drawLine((UpdateLine)i.next());
        }
    }
}

