/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;

public class PicView
extends Canvas {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private MediaTracker mediaTracker = new MediaTracker(this);
    private Image image;

    public PicView(String filename) {
        this.image = this.loadImage(filename);
        this.setSize(this.getDim());
    }

    private Dimension getDim() {
        Dimension d = new Dimension(0, 0);
        if (this.image != null) {
            d.width = this.image.getWidth(this);
            d.height = this.image.getHeight(this);
        }
        return d;
    }

    Image loadImage(String filename) {
        if (!new File(filename).exists()) {
            System.out.println("File " + filename + " not Found !");
            System.exit(1);
        }
        Image imageData = this.toolkit.getImage(filename);
        this.mediaTracker.addImage(imageData, 0);
        try {
            this.mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return imageData;
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getDim().width, this.getDim().height);
        g.drawImage(this.image, 0, 0, null);
    }
}

