/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.util.HashMap;
import org.jacorb.demo.notification.whiteboard.IFactoryOperations;
import org.jacorb.demo.notification.whiteboard.IFactoryPOA;
import org.jacorb.demo.notification.whiteboard.IWhiteBoard;
import org.jacorb.demo.notification.whiteboard.WhiteBoard;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class WhiteBoardFactory
extends IFactoryPOA
implements IFactoryOperations {
    HashMap boards;
    EventChannelFactory channelFactory_;
    POA poa_;
    ORB orb_;

    public WhiteBoardFactory(ORB orb, POA poa, EventChannelFactory ecf) {
        this._this(orb);
        this.boards = new HashMap();
        this.orb_ = orb;
        this.poa_ = poa;
        this.channelFactory_ = ecf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWhiteBoard getCreateWhiteboard(String name) {
        try {
            WhiteBoard board = null;
            board = (WhiteBoard)this.boards.get(name);
            if (board == null) {
                HashMap hashMap = this.boards;
                synchronized (hashMap) {
                    board = (WhiteBoard)this.boards.get(name);
                    if (board == null) {
                        System.out.println("Create board " + name);
                        IntHolder _channelId = new IntHolder();
                        EventChannel _channel = this.channelFactory_.create_channel(new Property[0], new Property[0], _channelId);
                        IntHolder _adminId = new IntHolder();
                        board = new WhiteBoard(this.orb_, _channel);
                        this.boards.put(name, board);
                    }
                }
            }
            System.out.println("return board");
            return board._this(this.orb_);
        }
        catch (UnsupportedAdmin ua) {
            ua.printStackTrace();
        }
        catch (UnsupportedQoS uqos) {
            uqos.printStackTrace();
        }
        catch (AdminLimitExceeded ale) {
            ale.printStackTrace();
        }
        throw new RuntimeException();
    }

    @Override
    public String[] listAllWhiteboards() {
        return this.boards.keySet().toArray(new String[0]);
    }

    public static void main(String[] args) {
        try {
            ORB _orb = ORB.init((String[])args, null);
            POA _poa = POAHelper.narrow((Object)_orb.resolve_initial_references("RootPOA"));
            NamingContext nc = NamingContextHelper.narrow((Object)_orb.resolve_initial_references("NameService"));
            EventChannelFactory _factory = args != null && args.length == 1 ? EventChannelFactoryHelper.narrow((Object)_orb.string_to_object(args[0])) : EventChannelFactoryHelper.narrow((Object)_orb.resolve_initial_references("NotificationService"));
            Object cob = _poa.servant_to_reference((Servant)new WhiteBoardFactory(_orb, _poa, _factory));
            NameComponent[] name = new NameComponent[]{new NameComponent("WhiteBoard", "Factory")};
            nc.rebind(name, cob);
            _poa.the_POAManager().activate();
            System.out.println("Whiteboard online !");
            boolean non_exist = false;
            try {
                non_exist = _factory._non_existent();
            }
            catch (SystemException e) {
                non_exist = true;
            }
            if (non_exist) {
                System.out.println("NotificationService not available !");
                System.exit(1);
            }
            _orb.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

