/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.demo.notification.whiteboard;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jacorb.demo.notification.whiteboard.BrushSizeDrawCanvas;
import org.jacorb.demo.notification.whiteboard.GhostPainter;
import org.jacorb.demo.notification.whiteboard.IWorkgroupFrame;
import org.jacorb.demo.notification.whiteboard.SelectDialog;
import org.jacorb.demo.notification.whiteboard.WorkgroupController;

public class WorkgroupFrame
extends Frame
implements IWorkgroupFrame {
    BrushSizeDrawCanvas drawCanvas_;
    SelectDialog dialog;
    GhostPainter ghost;
    WorkgroupController controller_;
    private Panel panel1;
    private Button draw;
    private Button delete;
    private Button clear;
    private MenuBar menuBar1;
    private Menu menu1;
    private MenuItem select;
    private MenuItem exit;
    private MenuItem activateGhost;
    private MenuItem leaveMenuItem_;
    private TextField currentBoard;

    public BrushSizeDrawCanvas getDrawCanvas() {
        return this.drawCanvas_;
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public List getList() {
        String[] s = this.controller_.getListOfWhiteboards();
        ArrayList<String> v = new ArrayList<String>();
        for (int n = 0; n < s.length; ++n) {
            v.add(s[n]);
        }
        return Collections.unmodifiableList(v);
    }

    public void setCurrentBoardText(String name) {
        this.currentBoard.setText(name);
    }

    public void setLeaveMenuItem(boolean value) {
        this.leaveMenuItem_.setEnabled(value);
    }

    public WorkgroupFrame(WorkgroupController wg, String name) {
        super(name);
        this.controller_ = wg;
        this.initComponents();
        this.pack();
    }

    public WorkgroupFrame(WorkgroupController wg) {
        this(wg, "Whiteboard");
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WorkgroupFrame.this.exitForm(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.drawCanvas_ = new BrushSizeDrawCanvas(this.controller_, 400, 400);
        this.add((Component)this.drawCanvas_, "Center");
        this.menuBar1 = new MenuBar();
        this.menu1 = new Menu();
        this.menu1.setLabel("Menu");
        this.select = new MenuItem();
        this.select.setLabel("Select");
        this.select.setName("select");
        this.select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkgroupFrame.this.selectActionPerformed(evt);
            }
        });
        this.menu1.add(this.select);
        this.leaveMenuItem_ = new MenuItem();
        this.leaveMenuItem_.setEnabled(false);
        this.leaveMenuItem_.setLabel("Leave");
        this.leaveMenuItem_.setName("leave");
        this.leaveMenuItem_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkgroupFrame.this.leaveActionPerformed(evt);
            }
        });
        this.menu1.add(this.leaveMenuItem_);
        this.activateGhost = new MenuItem();
        this.activateGhost.setLabel("Start Daemon");
        this.activateGhost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkgroupFrame.this.activateGhostActionPerformed();
            }
        });
        this.exit = new MenuItem();
        this.exit.setLabel("Exit");
        this.exit.setName("exit");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkgroupFrame.this.exitActionPerformed(evt);
            }
        });
        this.menu1.add(this.exit);
        this.menuBar1.add(this.menu1);
        this.setMenuBar(this.menuBar1);
        this.panel1 = new Panel();
        this.panel1.setLayout(new FlowLayout());
        this.draw = new Button();
        this.draw.setLabel("Draw");
        this.draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkgroupFrame.this.drawActionPerformed(evt);
            }
        });
        this.panel1.add(this.draw);
        this.delete = new Button();
        this.delete.setLabel("Delete");
        this.delete.setName("delete");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkgroupFrame.this.deleteActionPerformed(evt);
            }
        });
        this.panel1.add(this.delete);
        this.clear = new Button();
        this.clear.setLabel("Clear");
        this.clear.setName("clear");
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkgroupFrame.this.clearActionPerformed(evt);
            }
        });
        this.panel1.add(this.clear);
        this.currentBoard = new TextField(12);
        this.currentBoard.setName("currentboard");
        this.currentBoard.setEditable(false);
        this.currentBoard.setText("No Selection");
        this.panel1.add(this.currentBoard);
        this.add((Component)this.panel1, "South");
    }

    private void activateGhostActionPerformed() {
        if (this.activateGhost.getLabel() == "Start Daemon") {
            this.ghost = new GhostPainter(this, 400, 400);
            this.ghost.start();
            this.activateGhost.setLabel("Stop Daemon");
        } else {
            this.ghost.shutdown();
            this.activateGhost.setLabel("Start Daemon");
        }
    }

    private void clearActionPerformed(ActionEvent evt) {
        this.drawCanvas_.clearAll();
    }

    private void deleteActionPerformed(ActionEvent evt) {
        this.drawCanvas_.setDrawColor(0, 0, 0);
        this.drawCanvas_.setBrushSize(5);
    }

    private void drawActionPerformed(ActionEvent evt) {
        this.drawCanvas_.setDrawColor(255, 255, 255);
        this.drawCanvas_.setBrushSize(1);
    }

    private void exitActionPerformed(ActionEvent evt) {
        this.controller_.exit();
    }

    private void leaveActionPerformed(ActionEvent evt) {
        this.leaveMenuItem_.setEnabled(false);
        this.currentBoard.setText("No Selection");
        this.controller_.leaveWhiteboard();
    }

    private void selectActionPerformed(ActionEvent evt) {
        this.dialog = new SelectDialog((Frame)this, this.controller_);
        this.dialog.show();
    }

    private void exitForm(WindowEvent evt) {
        this.controller_.exit();
    }
}

