/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.container.CORBAObjectComponentAdapter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStageSource;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.AbstractSupplierAdmin;
import org.jacorb.notification.servant.ECProxyPullConsumerImpl;
import org.jacorb.notification.servant.ECProxyPushConsumerImpl;
import org.jacorb.notification.servant.IEventChannel;
import org.jacorb.notification.servant.ProxyPullConsumerImpl;
import org.jacorb.notification.servant.ProxyPushConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPullConsumerImpl;
import org.jacorb.notification.servant.SequenceProxyPushConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPullConsumerImpl;
import org.jacorb.notification.servant.StructuredProxyPushConsumerImpl;
import org.jacorb.notification.servant.SupplierAdminImplMBean;
import org.jacorb.notification.util.CollectionsWrapper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosEventChannelAdmin.ProxyPullConsumer;
import org.omg.CosEventChannelAdmin.ProxyPullConsumerHelper;
import org.omg.CosEventChannelAdmin.ProxyPushConsumer;
import org.omg.CosEventChannelAdmin.ProxyPushConsumerHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyChannelAdmin.SupplierAdminHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdminOperations;
import org.omg.CosNotifyChannelAdmin.SupplierAdminPOATie;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.CachingComponentAdapter;

public class SupplierAdminImpl
extends AbstractSupplierAdmin
implements SupplierAdminOperations,
Disposable,
SupplierAdminImplMBean {
    private FilterStageSource subsequentFilterStagesSource_;
    private final SupplierAdmin thisCorbaRef_ = SupplierAdminHelper.narrow(this.activate());

    public SupplierAdminImpl(IEventChannel channelServant, ORB orb, POA poa, Configuration config, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(channelServant, orb, poa, config, messageFactory, offerManager, subscriptionManager);
        this.container_.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new CORBAObjectComponentAdapter(SupplierAdmin.class, this.thisCorbaRef_)));
        this.registerDisposable(new Disposable(){

            public void dispose() {
                SupplierAdminImpl.this.container_.unregisterComponent(SupplierAdmin.class);
            }
        });
    }

    @Override
    public Servant newServant() {
        return new SupplierAdminPOATie(this);
    }

    @Override
    public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.offerManager_.offer_change(added, removed);
    }

    @Override
    public int[] pull_consumers() {
        return this.get_all_notify_proxies(this.pullServants_, this.modifyProxiesLock_);
    }

    @Override
    public int[] push_consumers() {
        return this.get_all_notify_proxies(this.pushServants_, this.modifyProxiesLock_);
    }

    @Override
    public ProxyConsumer obtain_notification_pull_consumer(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy _servant = this.obtain_notification_pull_consumer_servant(clientType);
            intHolder.value = _servant.getID();
            return ProxyConsumerHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_notification_pull_consumer: unexpected error", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    private AbstractProxy obtain_notification_pull_consumer_servant(ClientType clientType) throws Exception {
        AbstractProxy _servant = this.newProxyPullConsumer(clientType);
        this.configureInterFilterGroupOperator(_servant);
        this.configureQoS(_servant);
        this.addProxyToMap(_servant, this.pullServants_, this.modifyProxiesLock_);
        return _servant;
    }

    @Override
    public ProxyConsumer get_proxy_consumer(int id) throws ProxyNotFound {
        return ProxyConsumerHelper.narrow(this.getProxy(id).activate());
    }

    @Override
    public ProxyConsumer obtain_notification_push_consumer(ClientType clienttype, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy _servant = this.obtain_notification_push_consumer_servant(clienttype);
            intHolder.value = _servant.getID();
            return ProxyConsumerHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_notification_push_consumer: unexpected error", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    private AbstractProxy obtain_notification_push_consumer_servant(ClientType clientType) throws Exception {
        AbstractProxy _servant = this.newProxyPushConsumer(clientType);
        this.configureInterFilterGroupOperator(_servant);
        this.configureQoS(_servant);
        this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
        return _servant;
    }

    @Override
    public ProxyPushConsumer obtain_push_consumer() {
        try {
            MutablePicoContainer _container = this.newContainerForEventStyleProxy();
            _container.registerComponentImplementation(AbstractProxyConsumer.class, ECProxyPushConsumerImpl.class);
            AbstractProxyConsumer _servant = (AbstractProxyConsumer)_container.getComponentInstanceOfType(AbstractProxyConsumer.class);
            _servant.setSubsequentDestinations(CollectionsWrapper.singletonList(this));
            this.configureQoS(_servant);
            this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
            return ProxyPushConsumerHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_push_consumer: unexpected error", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    @Override
    public ProxyPullConsumer obtain_pull_consumer() {
        try {
            MutablePicoContainer _container = this.newContainerForEventStyleProxy();
            _container.registerComponentImplementation(AbstractProxyConsumer.class, ECProxyPullConsumerImpl.class);
            AbstractProxyConsumer _servant = (AbstractProxyConsumer)_container.getComponentInstanceOfType(AbstractProxyConsumer.class);
            _servant.setSubsequentDestinations(CollectionsWrapper.singletonList(this));
            this.configureQoS(_servant);
            this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
            return ProxyPullConsumerHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_pull_consumer: unexpected error", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    @Override
    public List getSubsequentFilterStages() {
        return this.subsequentFilterStagesSource_.getSubsequentFilterStages();
    }

    @Override
    public void setSubsequentFilterStageSource(FilterStageSource source) {
        this.subsequentFilterStagesSource_ = source;
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMessageConsumer() {
        return false;
    }

    @Override
    public boolean hasInterFilterGroupOperatorOR() {
        return false;
    }

    AbstractProxy newProxyPullConsumer(ClientType clientType) {
        Class _clazz;
        switch (clientType.value()) {
            case 0: {
                _clazz = ProxyPullConsumerImpl.class;
                break;
            }
            case 1: {
                _clazz = StructuredProxyPullConsumerImpl.class;
                break;
            }
            case 2: {
                _clazz = SequenceProxyPullConsumerImpl.class;
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid ClientType: ClientType." + clientType.value());
            }
        }
        MutablePicoContainer _containerForProxy = this.newContainerForNotifyStyleProxy();
        _containerForProxy.registerComponentImplementation(AbstractProxyConsumer.class, _clazz);
        AbstractProxyConsumer _servant = (AbstractProxyConsumer)_containerForProxy.getComponentInstanceOfType(AbstractProxyConsumer.class);
        _servant.setSubsequentDestinations(CollectionsWrapper.singletonList(this));
        return _servant;
    }

    private AbstractProxy newProxyPushConsumer(ClientType clientType) {
        Class _proxyClazz;
        switch (clientType.value()) {
            case 0: {
                _proxyClazz = ProxyPushConsumerImpl.class;
                break;
            }
            case 1: {
                _proxyClazz = StructuredProxyPushConsumerImpl.class;
                break;
            }
            case 2: {
                _proxyClazz = SequenceProxyPushConsumerImpl.class;
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid ClientType: ClientType." + clientType.value());
            }
        }
        MutablePicoContainer _containerForProxy = this.newContainerForNotifyStyleProxy();
        _containerForProxy.registerComponentImplementation(AbstractProxyConsumer.class, _proxyClazz);
        AbstractProxyConsumer _servant = (AbstractProxyConsumer)_containerForProxy.getComponentInstanceOfType(AbstractProxyConsumer.class);
        _servant.setSubsequentDestinations(CollectionsWrapper.singletonList(this));
        return _servant;
    }

    @Override
    public String getMBeanType() {
        return "SupplierAdmin";
    }
}

