/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.container;

import org.jacorb.config.Configuration;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.filter.DefaultFilterFactoryDelegate;
import org.jacorb.notification.filter.FilterFactoryImpl;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.PatternWrapper;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.slf4j.Logger;

class FilterFactoryComponentAdapter
extends AbstractComponentAdapter {
    private static final long serialVersionUID = 1L;
    private final Logger logger_ = LogUtil.getLogger(((Object)((Object)this)).getClass().getName());

    public FilterFactoryComponentAdapter() {
        super(FilterFactory.class, FilterFactory.class);
    }

    public void verify(PicoContainer container) {
    }

    public Object getComponentInstance(PicoContainer container) {
        if (!"builtin".equals(this.getFilterFactoryLocation(container))) {
            try {
                return this.lookupFilterFactory(container);
            }
            catch (Exception e) {
                this.logger_.info("Could not resolve FilterFactory. Will fall back to builtin FilterFactory.", (Throwable)e);
            }
        }
        return this.newFilterFactory(container);
    }

    private FilterFactory newFilterFactory(PicoContainer container) {
        PatternWrapper.class.getName();
        final MutablePicoContainer _parent = (MutablePicoContainer)container;
        final MutablePicoContainer _container = _parent.makeChildContainer();
        _container.registerComponentImplementation(DefaultFilterFactoryDelegate.class);
        _container.registerComponentImplementation(FilterFactoryImpl.class);
        _container.registerComponentInstance(IContainer.class, (Object)new IContainer(){

            @Override
            public MutablePicoContainer getContainer() {
                return _container;
            }

            @Override
            public void destroy() {
                _parent.removeChildContainer((PicoContainer)_container);
            }
        });
        FilterFactoryImpl servant = (FilterFactoryImpl)_container.getComponentInstanceOfType(FilterFactoryImpl.class);
        return FilterFactoryHelper.narrow(servant.activate());
    }

    private FilterFactory lookupFilterFactory(PicoContainer container) {
        String _filterFactoryConf = this.getFilterFactoryLocation(container);
        ORB orb = (ORB)container.getComponentInstance(ORB.class);
        return FilterFactoryHelper.narrow(orb.string_to_object(_filterFactoryConf));
    }

    private String getFilterFactoryLocation(PicoContainer container) {
        Configuration config = (Configuration)container.getComponentInstance(Configuration.class);
        String _location = config.getAttribute("jacorb.notification.default_filter_factory", "builtin");
        return _location;
    }
}

