/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.util.Hashtable;
import org.jacorb.orb.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.otid_t;
import org.slf4j.Logger;

public class TransactionCurrentImpl
extends LocalObject
implements Current {
    private static final int DEFAULT_TIMEOUT = 30;
    private Hashtable contexts = null;
    private Hashtable timeouts = null;
    private ORB orb = null;
    private static int slot_id = -1;
    private static Logger logger;
    private TransactionFactory factory = null;

    public TransactionCurrentImpl(ORB orb, int slot_id) {
        this.orb = orb;
        TransactionCurrentImpl.slot_id = slot_id;
        logger = orb.getConfiguration().getLogger("jacorb.tx_service.current");
        this.contexts = new Hashtable();
        this.timeouts = new Hashtable();
        try {
            NamingContextExt nc = NamingContextExtHelper.narrow((Object)orb.resolve_initial_references("NameService"));
            NameComponent[] name = new NameComponent[]{new NameComponent("TransactionService", "service")};
            this.factory = TransactionFactoryHelper.narrow(nc.resolve(name));
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("Unable to obtain Transaction Service reference. Giving up.", (Throwable)e);
            }
            throw new Error(e.getMessage());
        }
    }

    public TransactionCurrentImpl() {
        this.contexts = new Hashtable();
        this.timeouts = new Hashtable();
    }

    public static Control getControl(org.omg.CORBA.ORB orb) {
        try {
            org.omg.PortableInterceptor.Current pi_current = (org.omg.PortableInterceptor.Current)orb.resolve_initial_references("PICurrent");
            PropagationContext context = PropagationContextHelper.extract(pi_current.get_slot(slot_id));
            return ControlHelper.extract(context.implementation_specific_data);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to obtain Transaction Service reference. Giving up.", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public void begin() throws SubtransactionsUnavailable {
        block3: {
            Thread thread = Thread.currentThread();
            if (this.contexts.containsKey(thread)) {
                throw new SubtransactionsUnavailable();
            }
            int timeout = this.timeouts.containsKey(thread) ? (Integer)this.timeouts.get(thread) : 30;
            Control control = this.factory.create(timeout);
            this.contexts.put(thread, control);
            try {
                org.omg.PortableInterceptor.Current pi_current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                TransIdentity id = new TransIdentity(control.get_coordinator(), control.get_terminator(), new otid_t(0, 0, new byte[0]));
                Any control_any = this.orb.create_any();
                ControlHelper.insert(control_any, control);
                PropagationContext context = new PropagationContext(timeout, id, new TransIdentity[0], control_any);
                Any context_any = this.orb.create_any();
                PropagationContextHelper.insert(context_any, context);
                pi_current.set_slot(slot_id, context_any);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Exception: ", (Throwable)e);
            }
        }
    }

    @Override
    public void commit(boolean report_heuristics) throws NoTransaction, HeuristicMixed, HeuristicHazard {
        block5: {
            Thread current = Thread.currentThread();
            if (!this.contexts.containsKey(current)) {
                throw new NoTransaction();
            }
            Control control = null;
            try {
                control = (Control)this.contexts.get(current);
                control.get_terminator().commit(report_heuristics);
                control._release();
                this.removeContext(current);
            }
            catch (TRANSACTION_ROLLEDBACK tr) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TRANSACTION_ROLLEDBACK: ", (Throwable)tr);
                }
                control._release();
                this.removeContext(current);
                throw tr;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Exception: ", (Throwable)e);
            }
        }
    }

    @Override
    public Control get_control() {
        return (Control)this.contexts.get(Thread.currentThread());
    }

    @Override
    public Status get_status() {
        Thread current = Thread.currentThread();
        if (!this.contexts.containsKey(current)) {
            return null;
        }
        try {
            return ((Control)this.contexts.get(current)).get_coordinator().get_status();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception: ", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String get_transaction_name() {
        Thread current = Thread.currentThread();
        if (!this.contexts.containsKey(current)) {
            return null;
        }
        try {
            return ((Control)this.contexts.get(current)).get_coordinator().get_transaction_name();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception: ", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public void resume(Control which) throws InvalidControl {
        this.setCurrentThreadContext(which);
    }

    @Override
    public void rollback() throws NoTransaction {
        block3: {
            Thread current = Thread.currentThread();
            if (!this.contexts.containsKey(current)) {
                throw new NoTransaction();
            }
            try {
                Control control = (Control)this.contexts.get(current);
                control.get_terminator().rollback();
                control._release();
                this.removeContext(current);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Exception: ", (Throwable)e);
            }
        }
    }

    @Override
    public void rollback_only() throws NoTransaction {
        block3: {
            Thread current = Thread.currentThread();
            if (!this.contexts.containsKey(current)) {
                throw new NoTransaction();
            }
            try {
                Control control = (Control)this.contexts.get(current);
                control.get_coordinator().rollback_only();
                control._release();
                this.removeContext(current);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Exception: ", (Throwable)e);
            }
        }
    }

    @Override
    public void set_timeout(int seconds) {
        this.timeouts.put(Thread.currentThread(), new Integer(seconds));
    }

    @Override
    public Control suspend() {
        Control result = this.get_control();
        this.removeContext(Thread.currentThread());
        return result;
    }

    public void setCurrentThreadContext(Control control) {
        block2: {
            Thread thread = Thread.currentThread();
            this.contexts.put(thread, control);
            try {
                org.omg.PortableInterceptor.Current pi_current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                TransIdentity id = new TransIdentity(control.get_coordinator(), control.get_terminator(), new otid_t(0, 0, new byte[0]));
                Any control_any = this.orb.create_any();
                ControlHelper.insert(control_any, control);
                int timeout = this.timeouts.containsKey(thread) ? (Integer)this.timeouts.get(thread) : 30;
                PropagationContext context = new PropagationContext(timeout, id, new TransIdentity[0], control_any);
                Any context_any = this.orb.create_any();
                PropagationContextHelper.insert(context_any, context);
                pi_current.set_slot(slot_id, context_any);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Exception: ", (Throwable)e);
            }
        }
    }

    private void removeContext(Thread current) {
        block2: {
            this.contexts.remove(current);
            try {
                org.omg.PortableInterceptor.Current pi_current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                Any empty = this.orb.create_any();
                pi_current.set_slot(slot_id, empty);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Exception: ", (Throwable)e);
            }
        }
    }
}

