/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import org.jacorb.notification.util.DefaultWildcardMap;
import org.jacorb.notification.util.WildcardMap;

public class CachingWildcardMap
implements WildcardMap {
    private final Object[] cachedKeys_;
    private final Object[][] cachedValues_;
    private Object victimKey_;
    private Object[] victimValue_;
    private final int cacheSize_;
    private final WildcardMap delegate_;

    public CachingWildcardMap() {
        this(4, new DefaultWildcardMap());
    }

    public CachingWildcardMap(int cacheSize, WildcardMap delegate) {
        this.cachedValues_ = new Object[cacheSize][];
        this.cachedKeys_ = new Object[cacheSize];
        this.cacheSize_ = cacheSize;
        this.delegate_ = delegate;
    }

    private int calcPosition(String key) {
        return key.charAt(0) % this.cacheSize_;
    }

    private void invalidateCache() {
        for (int x = 0; x < this.cacheSize_; ++x) {
            this.cachedKeys_[x] = null;
        }
        this.victimKey_ = null;
    }

    @Override
    public void clear() {
        this.invalidateCache();
        this.delegate_.clear();
    }

    @Override
    public Object remove(Object key) {
        this.invalidateCache();
        return this.delegate_.remove(key);
    }

    @Override
    public Object put(Object key, Object value) {
        this.invalidateCache();
        return this.delegate_.put(key, value);
    }

    @Override
    public Object[] getWithExpansion(Object key) {
        Object[] _ret;
        int _pos;
        String _key = key.toString();
        if (_key.equals(this.cachedKeys_[_pos = this.calcPosition(_key)])) {
            _ret = this.cachedValues_[_pos];
        } else if (_key.equals(this.victimKey_)) {
            _ret = this.victimValue_;
        } else {
            _ret = this.delegate_.getWithExpansion(key);
            this.victimKey_ = this.cachedKeys_[_pos];
            this.victimValue_ = this.cachedValues_[_pos];
            this.cachedKeys_[_pos] = _key;
            this.cachedValues_[_pos] = _ret;
        }
        return _ret;
    }

    @Override
    public Object getNoExpansion(Object key) {
        return this.delegate_.getNoExpansion(key);
    }
}

