/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import org.jacorb.collection.CollectionImpl;
import org.jacorb.collection.KeySortedCollectionImpl;
import org.jacorb.collection.KeySortedIteratorImpl;
import org.jacorb.collection.util.ObjectInvalid;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosCollection.ElementInvalid;
import org.omg.CosCollection.EqualityKeySortedIteratorOperations;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.LowerBoundStyle;
import org.omg.CosCollection.UpperBoundStyle;

class EqualityKeySortedIteratorImpl
extends KeySortedIteratorImpl
implements EqualityKeySortedIteratorOperations {
    EqualityKeySortedIteratorImpl(KeySortedCollectionImpl collection) {
        super(collection);
    }

    EqualityKeySortedIteratorImpl(KeySortedCollectionImpl collection, boolean read_only) {
        super(collection, read_only);
    }

    EqualityKeySortedIteratorImpl(KeySortedCollectionImpl collection, boolean read_only, boolean reverse) {
        super(collection, read_only, reverse);
    }

    @Override
    public boolean set_to_element_with_value(Any element) throws ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.collection.check_element(element);
            try {
                int pos = this.collection.data.indexOf(element);
                if (pos >= 0) {
                    this.set_pos(pos);
                    this.set_in_between(false);
                    return true;
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    @Override
    public boolean set_to_next_element_with_value(Any element) throws IteratorInvalid, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            this.collection.check_element(element);
            try {
                int start_pos;
                int pos = this.collection.data.indexOf(element);
                int n = start_pos = this.is_in_between() ? this.get_pos() : this.get_pos() + 1;
                if (pos >= 0 && start_pos < this.collection.data.size() - 1) {
                    if (start_pos > pos && !this.collection.ops.equal(element, (Any)this.collection.data.elementAt(start_pos))) {
                        this.invalidate();
                        return false;
                    }
                    this.set_pos(start_pos);
                    this.set_in_between(false);
                    return true;
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_to_next_element_with_different_value() throws IteratorInBetween, IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            int pos;
            this.check_iterator();
            Any element = (Any)this.collection.data.elementAt(this.get_pos());
            for (pos = this.get_pos() + 1; pos < this.collection.data.size() && this.collection.ops.equal(element, (Any)this.collection.data.elementAt(pos)); ++pos) {
            }
            if (pos >= this.collection.data.size()) {
                this.invalidate();
                return false;
            }
            this.set_pos(pos);
            return true;
        }
    }

    @Override
    public boolean set_to_first_element_with_value(Any element, LowerBoundStyle style) throws ElementInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public boolean set_to_last_element_with_value(Any element, UpperBoundStyle style) throws ElementInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public boolean set_to_previous_element_with_value(Any element) throws IteratorInvalid, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            this.collection.check_element(element);
            try {
                int pos = this.collection.data.indexOf(element);
                int start_pos = this.get_pos() - 1;
                if (pos >= 0 && start_pos < this.collection.data.size()) {
                    if (start_pos < pos && !this.collection.ops.equal(element, (Any)this.collection.data.elementAt(start_pos))) {
                        this.invalidate();
                        return false;
                    }
                    this.set_pos(start_pos);
                    this.set_in_between(false);
                    return true;
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_to_previous_element_with_different_value() throws IteratorInBetween, IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            int pos;
            this.check_iterator();
            Any element = (Any)this.collection.data.elementAt(this.get_pos());
            for (pos = this.get_pos() - 1; pos >= 0 && this.collection.ops.equal(element, (Any)this.collection.data.elementAt(pos)); --pos) {
            }
            if (pos < 0) {
                this.invalidate();
                return false;
            }
            this.set_pos(pos);
            return true;
        }
    }
}

