/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection.util;

import org.jacorb.collection.util.DynArray;

public class ArrayFactory {
    private static final int MAX = 16;
    private static final int MIN_OFFSET = 4;
    private static final int THREASHOLD = 16;
    private static DynArray[] pool = new DynArray[16];

    private static final int log2(int n) {
        int l = 0;
        int nn = n - 1;
        while (nn >> l != 0) {
            ++l;
        }
        return l;
    }

    public static void release() {
        int i = 16;
        while (i > 0) {
            pool[--i].removeAllElements();
        }
    }

    public static synchronized Object[] get_array(int capacity) {
        DynArray v;
        int log = 0;
        if (capacity != 0) {
            log = ArrayFactory.log2(capacity);
        }
        if (!(v = pool[log > 4 ? log - 4 : 0]).isEmpty()) {
            Object o = v.lastElement();
            v.removeElementAt(v.size() - 1);
            return (Object[])o;
        }
        return new Object[log > 4 ? 1 << log : 16];
    }

    public static synchronized void free_array(Object[] current) {
        int log_curr = ArrayFactory.log2(current.length);
        if (log_curr - 4 < pool.length) {
            ArrayFactory.clear_array(current);
            DynArray v = pool[log_curr - 4];
            if (v.size() < 16) {
                v.addElement(current);
            }
        }
    }

    private static void clear_array(Object[] current) {
        int i = current.length;
        while (i > 0) {
            current[--i] = null;
        }
    }

    static {
        int i = 16;
        while (i > 0) {
            ArrayFactory.pool[--i] = new DynArray();
        }
    }
}

