/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class CollectionsWrapper {
    private static Method singletonListMethod;

    public static List singletonList(Object o) {
        if (singletonListMethod != null) {
            try {
                return (List)singletonListMethod.invoke(null, o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new SingletonList(o);
    }

    static {
        try {
            singletonListMethod = Collections.class.getMethod("singletonList", Object.class);
        }
        catch (Exception e) {
            singletonListMethod = null;
        }
    }

    private static class SingletonList
    extends AbstractList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object singletonElement_;

        SingletonList(Object element) {
            this.singletonElement_ = element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            if (this.singletonElement_ == null) {
                return object == null;
            }
            return object.equals(this.singletonElement_);
        }

        @Override
        public Object get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return this.singletonElement_;
        }
    }
}

