/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.impl;

import org.jacorb.config.Configuration;
import org.jacorb.notification.filter.ETCLEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CosNotification.Property;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynUnionHelper;
import org.slf4j.Logger;

public class DefaultETCLEvaluator
implements ETCLEvaluator {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private final Logger logger_;
    private final DynAnyFactory dynAnyFactory_;
    private final ORB orb_;
    private final Any TRUE_ANY;
    private final Any FALSE_ANY;

    public DefaultETCLEvaluator(ORB orb, Configuration config, DynAnyFactory dynAnyFactory) {
        this.orb_ = orb;
        this.logger_ = config.getLogger(this.getClass().getName());
        this.dynAnyFactory_ = dynAnyFactory;
        this.TRUE_ANY = this.orb_.create_any();
        this.FALSE_ANY = this.orb_.create_any();
        this.TRUE_ANY.insert_boolean(true);
        this.FALSE_ANY.insert_boolean(false);
    }

    @Override
    public boolean hasDefaultDiscriminator(Any any) throws EvaluationException {
        try {
            return any.type().default_index() != -1;
        }
        catch (BadKind e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    @Override
    public Any evaluateExistIdentifier(Any value, String identifier) throws EvaluationException {
        try {
            this.evaluateIdentifier(value, identifier);
            return this.TRUE_ANY;
        }
        catch (EvaluationException e) {
            return this.FALSE_ANY;
        }
    }

    @Override
    public Any evaluateTypeName(Any value) throws EvaluationException {
        try {
            TypeCode _tc = value.type();
            Any _ret = this.orb_.create_any();
            _ret.insert_string(_tc.name());
            return _ret;
        }
        catch (BadKind e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    @Override
    public Any evaluateRepositoryId(Any value) throws EvaluationException {
        try {
            TypeCode _tc = value.type();
            Any _ret = this.orb_.create_any();
            _ret.insert_string(_tc.id());
            return _ret;
        }
        catch (BadKind e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    @Override
    public Any evaluateListLength(Any value) throws EvaluationException {
        int _length;
        switch (value.type().kind().value()) {
            case 20: {
                DynAny _dynAny = this.toDynAny(value);
                _length = _dynAny.component_count();
                break;
            }
            case 19: {
                DynSequence _dynSequence = this.toDynSequence(value);
                _length = _dynSequence.get_length();
                break;
            }
            default: {
                throw new EvaluationException("Neither array nor sequence");
            }
        }
        Any _any = this.orb_.create_any();
        _any.insert_long(_length);
        return _any;
    }

    private String getDefaultUnionMemberName(TypeCode unionTypeCode) throws EvaluationException {
        try {
            int _defaultIndex = unionTypeCode.default_index();
            if (_defaultIndex != -1) {
                return unionTypeCode.member_name(_defaultIndex);
            }
        }
        catch (BadKind e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
        catch (Bounds e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
        throw new EvaluationException();
    }

    private String getUnionMemberNameFromDiscriminator(TypeCode unionTypeCode, int discriminator) throws EvaluationException {
        try {
            Any _any = this.orb_.create_any();
            switch (unionTypeCode.discriminator_type().kind().value()) {
                case 3: {
                    _any.insert_long(discriminator);
                    break;
                }
                case 5: {
                    _any.insert_ulong(discriminator);
                    break;
                }
                case 2: {
                    _any.insert_short((short)discriminator);
                    break;
                }
                case 7: {
                    _any.insert_double((double)discriminator);
                    break;
                }
                case 4: {
                    _any.insert_ushort((short)discriminator);
                }
            }
            int _memberCount = unionTypeCode.member_count();
            try {
                for (int _x = 0; _x < _memberCount; ++_x) {
                    if (!_any.equal(unionTypeCode.member_label(_x))) continue;
                    return unionTypeCode.member_name(_x);
                }
            }
            catch (Bounds b) {
                throw new RuntimeException();
            }
        }
        catch (BadKind e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
        throw new EvaluationException();
    }

    @Override
    public Any evaluateUnion(Any value) throws EvaluationException {
        String _defaultMemberName = this.getDefaultUnionMemberName(value.type());
        return this.evaluateIdentifier(value, _defaultMemberName);
    }

    @Override
    public Any evaluateUnion(Any value, int position) throws EvaluationException {
        DynUnion _dynUnion = this.toDynUnion(value);
        _dynUnion.seek(0);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extract idx: " + position + " from Union " + _dynUnion.type());
        }
        String _discrimName = this.getUnionMemberNameFromDiscriminator(value.type(), position);
        return this.evaluateIdentifier((DynAny)_dynUnion, _discrimName);
    }

    @Override
    public Any evaluatePropertyList(Property[] list, String name) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluatePropertyList " + list);
            this.logger_.debug("list length: " + list.length);
        }
        for (int x = 0; x < list.length; ++x) {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug(x + ": " + list[x].name + " => " + list[x].value);
            }
            if (!name.equals(list[x].name)) continue;
            return list[x].value;
        }
        return null;
    }

    @Override
    public Any evaluateNamedValueList(Any any, String name) throws EvaluationException {
        try {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluateNamedValueList(" + any + ", " + name + ")");
            }
            DynAny _dynAny = this.toDynAny(any);
            int _count = _dynAny.component_count();
            Any _ret = null;
            _dynAny.rewind();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Entries: " + _count);
            }
            for (int _x = 0; _x < _count; ++_x) {
                _dynAny.seek(_x);
                DynAny _cursor = _dynAny.current_component();
                _ret = this.evaluateNamedValue(_cursor, name);
                if (_ret != null) break;
            }
            return _ret;
        }
        catch (TypeMismatch e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    private Any evaluateNamedValue(DynAny any, String name) throws EvaluationException {
        Any _result;
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluate assoc " + name + " on a Any of type: " + any.type());
        }
        String _anyName = this.evaluateIdentifier(any, NAME).extract_string();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("test if " + name + " == " + _anyName);
        }
        if (name.equals(_anyName)) {
            this.logger_.debug("YES");
            _result = this.evaluateIdentifier(any, VALUE);
        } else {
            _result = null;
        }
        return _result;
    }

    @Override
    public Any evaluateArrayIndex(Any any, int index) throws EvaluationException {
        try {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluate array idx " + index + " on a Any of type: " + any.type());
            }
            DynAny _dynAny = this.toDynAny(any);
            _dynAny.rewind();
            _dynAny.seek(index);
            DynAny _cursor = _dynAny.current_component();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluation result is of type: " + _cursor.type());
            }
            return _cursor.to_any();
        }
        catch (TypeMismatch e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    private Any evaluateIdentifier(DynAny any, int position) throws EvaluationException {
        try {
            DynAny _result;
            switch (any.type().kind().value()) {
                case 15: {
                    any.seek(position);
                    _result = any.current_component();
                    break;
                }
                default: {
                    throw new EvaluationException("attempt to access member on non-struct");
                }
            }
            return _result.to_any();
        }
        catch (TypeMismatch e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    @Override
    public Any evaluateIdentifier(Any any, int position) throws EvaluationException {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluate idx " + position + " on Any");
        }
        DynAny _dynAny = this.toDynAny(any);
        return this.evaluateIdentifier(_dynAny, position);
    }

    @Override
    public Any evaluateDiscriminator(Any any) throws EvaluationException {
        switch (any.type().kind().value()) {
            case 16: {
                DynUnion _dynUnion = this.toDynUnion(any);
                return _dynUnion.get_discriminator().to_any();
            }
        }
        throw new EvaluationException("any does not contain member _d");
    }

    @Override
    public EvaluationResult evaluateElementInSequence(EvaluationContext context, EvaluationResult element, Any sequence) throws EvaluationException {
        try {
            DynSequence _dynSequence = DynSequenceHelper.narrow((Object)this.toDynAny(sequence));
            _dynSequence.rewind();
            do {
                DynAny _currentComponent;
                EvaluationResult _currentElement;
                if (element.compareTo(_currentElement = EvaluationResult.fromAny((_currentComponent = _dynSequence.current_component()).to_any())) != 0) continue;
                return EvaluationResult.BOOL_TRUE;
            } while (_dynSequence.next());
            return EvaluationResult.BOOL_FALSE;
        }
        catch (TypeMismatch e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    @Override
    public Any evaluateIdentifier(Any any, String identifier) throws EvaluationException {
        DynAny _dynAny = this.toDynAny(any);
        return this.evaluateIdentifier(_dynAny, identifier);
    }

    private Any evaluateIdentifier(DynAny any, String identifier) throws EvaluationException {
        try {
            String _strippedIdentifier = DefaultETCLEvaluator.stripBackslash(identifier);
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluate " + _strippedIdentifier + " on Any");
            }
            DynAny _cursor = any;
            block1 : switch (any.type().kind().value()) {
                case 15: {
                    this.logger_.debug("Any is a struct");
                    DynStruct _dynStruct = DynStructHelper.narrow((Object)any);
                    _dynStruct.rewind();
                    do {
                        String _currentName = _dynStruct.current_member_name();
                        if (this.logger_.isDebugEnabled()) {
                            this.logger_.debug(" => " + _currentName);
                        }
                        if (!_currentName.equals(_strippedIdentifier)) continue;
                        _cursor = _dynStruct.current_component();
                        break block1;
                    } while (_dynStruct.next());
                    throw new EvaluationException("struct has no member " + _strippedIdentifier);
                }
                case 16: {
                    DynUnion _dynUnion;
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug("Any is a Union");
                    }
                    if ((_dynUnion = this.toDynUnion(any)).member_name().equals(_strippedIdentifier)) {
                        _cursor = _dynUnion.member();
                        break;
                    }
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug(_dynUnion.member_name() + " != " + _strippedIdentifier);
                    }
                    throw new EvaluationException("member " + _strippedIdentifier + " is not active on struct");
                }
                case 11: {
                    this.logger_.debug("encapsulated any");
                    return this.evaluateIdentifier(any.get_any(), _strippedIdentifier);
                }
                default: {
                    this.logger_.debug("unknown " + any.type());
                    return null;
                }
            }
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Result: " + _cursor);
            }
            if (_cursor != null && this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluation result is of type: " + _cursor.type());
            }
            if (_cursor == null) {
                this.logger_.debug("Member not found");
                throw new EvaluationException("member not found");
            }
            return _cursor.to_any();
        }
        catch (InvalidValue e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
        catch (TypeMismatch e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    private DynAny toDynAny(Any any) throws EvaluationException {
        try {
            return this.dynAnyFactory_.create_dyn_any(any);
        }
        catch (InconsistentTypeCode e) {
            throw DefaultETCLEvaluator.newEvaluationException((Exception)((java.lang.Object)e));
        }
    }

    private DynUnion toDynUnion(Any any) throws EvaluationException {
        return DynUnionHelper.narrow((Object)this.toDynAny(any));
    }

    private DynUnion toDynUnion(DynAny dynAny) {
        return DynUnionHelper.narrow((Object)dynAny);
    }

    private DynSequence toDynSequence(Any any) throws EvaluationException {
        return DynSequenceHelper.narrow((Object)this.toDynAny(any));
    }

    private static String stripBackslash(String identifier) {
        StringBuffer _buffer = new StringBuffer();
        int _length = identifier.length();
        for (int _x = 0; _x < _length; ++_x) {
            if (identifier.charAt(_x) == '\\') continue;
            _buffer.append(identifier.charAt(_x));
        }
        return _buffer.toString();
    }

    private static EvaluationException newEvaluationException(Exception e) {
        return new EvaluationException(e.toString());
    }
}

