/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.slf4j.Logger;

public class ServerContextTransferInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private Codec codec = null;
    private int slot_id = -1;
    private Current ts_current;
    private ORB orb;
    private Logger logger;

    public ServerContextTransferInterceptor(Codec codec, int slot_id, Current ts_current, ORB orb) {
        this.codec = codec;
        this.slot_id = slot_id;
        this.ts_current = ts_current;
        this.orb = orb;
        this.logger = ((org.jacorb.orb.ORB)orb).getConfiguration().getLogger("org.jacorb.tx_service.interceptor");
    }

    public String name() {
        return "ServerContextTransferInterceptor";
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        block2: {
            try {
                ServiceContext ctx = ri.get_request_service_context(0);
                ri.set_slot(this.slot_id, this.codec.decode(ctx.context_data));
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Exception", (Throwable)e);
            }
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        block2: {
            try {
                org.omg.PortableInterceptor.Current pi_current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                PropagationContext context = PropagationContextHelper.extract(pi_current.get_slot(this.slot_id));
                Control control = ControlHelper.extract(context.implementation_specific_data);
                this.ts_current.resume(control);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Exception", (Throwable)e);
            }
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        this.ts_current.suspend();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.ts_current.suspend();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.ts_current.suspend();
    }
}

