/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import java.util.Vector;
import org.jacorb.collection.CollectionImpl;
import org.jacorb.collection.OrderedCollectionImpl;
import org.jacorb.collection.PositionalIteratorImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosCollection.AnySequenceHolder;
import org.omg.CosCollection.ElementInvalid;
import org.omg.CosCollection.Iterator;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.IteratorInvalidReason;
import org.omg.CosCollection.OrderedIteratorOperations;
import org.omg.CosCollection.PositionInvalid;

class OrderedIteratorImpl
extends PositionalIteratorImpl
implements OrderedIteratorOperations {
    protected boolean reverse;

    OrderedIteratorImpl(OrderedCollectionImpl collection) {
        super(collection);
        this.reverse = false;
    }

    OrderedIteratorImpl(OrderedCollectionImpl collection, boolean read_only) {
        super(collection, read_only);
        this.reverse = false;
    }

    OrderedIteratorImpl(OrderedCollectionImpl collection, boolean read_only, boolean reverse) {
        super(collection, read_only);
        if (reverse) {
            throw new NO_IMPLEMENT();
        }
        this.reverse = reverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_to_last_element() {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.set_pos(this.collection.data.size() - 1);
            this.set_in_between(false);
            return this.is_valid();
        }
    }

    @Override
    public boolean set_to_previous_element() throws IteratorInvalid {
        return this.set_to_nth_previous_element(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set_to_nth_previous_element(int n) throws IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            int new_pos = this.get_pos() - n;
            if (this.collection.number_of_elements() <= new_pos || new_pos < 0) {
                this.invalidate();
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
            this.set_pos(new_pos);
            this.set_in_between(false);
            return this.is_valid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set_to_position(int position) throws PositionInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            if (position < 0 || position >= this.collection.data.size()) {
                throw new PositionInvalid();
            }
            this.set_pos(position);
            this.set_in_between(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int position() throws IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            return this.get_pos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retrieve_element_set_to_previous(AnyHolder element, BooleanHolder more) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            try {
                element.value = this.collection.element_retrieve(this.pos);
            }
            catch (PositionInvalid e) {
                this.invalidate();
                throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
            }
            more.value = this.get_pos() > 0;
            return this.set_to_previous_element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retrieve_previous_n_elements(int n, AnySequenceHolder result, BooleanHolder more) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            Vector<Any> v = new Vector<Any>(n);
            AnyHolder a = new AnyHolder();
            for (int i = 0; (i < n || n == 0) && this.is_valid(); ++i) {
                try {
                    a.value = this.collection.element_retrieve(this.get_pos());
                    this.set_pos(this.get_pos() - 1);
                }
                catch (PositionInvalid e) {
                    this.invalidate();
                    throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
                }
                v.addElement(a.value);
                a.value = null;
            }
            boolean bl = more.value = this.get_pos() > 0;
            if (v.size() > 0) {
                result.value = new Any[v.size()];
                v.copyInto(result.value);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean not_equal_retrieve_element_set_to_previous(Iterator test, AnyHolder element) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            PositionalIteratorImpl iter = this.collection.check_iterator(test);
            iter.check_iterator();
            if (this.is_equal(test)) {
                this.retrieve_element(element);
                return false;
            }
            this.retrieve_element_set_to_previous(element, new BooleanHolder());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_element_set_to_previous() throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.remove_element();
            return this.set_to_previous_element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_previous_n_elements(int n, IntHolder actual_number) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            actual_number.value = 0;
            int i = 0;
            while ((i < n || n == 0) && this.is_valid()) {
                this.remove_element_set_to_previous();
                ++i;
                ++actual_number.value;
            }
            return this.is_valid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean not_equal_remove_element_set_to_previous(Iterator test) throws IteratorInvalid, IteratorInBetween {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            PositionalIteratorImpl iter = this.collection.check_iterator(test);
            iter.check_iterator();
            if (this.is_equal(test)) {
                this.remove_element();
                return false;
            }
            this.remove_element_set_to_previous();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace_element_set_to_previous(Any element) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.replace_element(element);
            return this.set_to_previous_element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace_previous_n_elements(Any[] elements, IntHolder actual_number) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            actual_number.value = 0;
            int i = 0;
            while (i < elements.length && this.is_valid()) {
                this.replace_element_set_to_previous(elements[i]);
                ++i;
                ++actual_number.value;
            }
            return this.is_valid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean not_equal_replace_element_set_to_previous(Iterator test, Any element) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            PositionalIteratorImpl iter = this.collection.check_iterator(test);
            iter.check_iterator();
            if (this.is_equal(test)) {
                this.replace_element(element);
                return false;
            }
            this.replace_element_set_to_previous(element);
            return true;
        }
    }

    @Override
    public boolean is_first() {
        return this.get_pos() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean is_last() {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            return this.collection.data.size() - 1 == this.get_pos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean is_for_same(Iterator test) {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            try {
                this.collection.check_iterator(test);
                return true;
            }
            catch (IteratorInvalid e) {
                return false;
            }
        }
    }

    @Override
    public synchronized boolean is_reverse() {
        return this.reverse;
    }
}

