/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.AbstractEventChannel;
import org.jacorb.notification.ChannelManager;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.IFactory;
import org.jacorb.notification.TypedEventChannelFactoryImpl;
import org.jacorb.notification.container.BiDirGiopPOAComponentAdapter;
import org.jacorb.notification.container.PicoContainerFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.lifecycle.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;

public abstract class AbstractChannelFactory
implements ManageableServant,
Disposable {
    private static final String STANDARD_IMPL_NAME = "JacORB-NotificationService";
    private static final long SHUTDOWN_INTERVAL = 1000L;
    private static final String EVENTCHANNEL_FACTORY_POA_NAME = "EventChannelFactoryPOA";
    private NameComponent[] registeredName_ = null;
    private NamingContext namingContext_;
    private Runnable destroyMethod_ = new Runnable(){

        @Override
        public void run() {
            AbstractChannelFactory.this.dispose();
        }
    };
    protected final MutablePicoContainer container_;
    protected final Configuration config_;
    protected final Object thisRef_;
    protected final Logger logger_;
    private final String ior_;
    private final String corbaLoc_;
    private final POA eventChannelFactoryPOA_;
    private final byte[] oid_;
    private final ChannelManager channelManager_ = new ChannelManager();
    private final AtomicInteger eventChannelIDPool_ = new AtomicInteger(0);
    private final DisposableManager disposableManager_ = new DisposableManager();

    protected AbstractChannelFactory(final MutablePicoContainer container, ORB orb) throws UserException {
        this.container_ = PicoContainerFactory.createRootContainer(container, (org.jacorb.orb.ORB)orb);
        if (container != null) {
            this.disposableManager_.addDisposable(new Disposable(){

                public void dispose() {
                    container.removeChildContainer((PicoContainer)AbstractChannelFactory.this.container_);
                }
            });
        }
        this.disposableManager_.addDisposable(new Disposable(){

            public void dispose() {
                POA _poa = (POA)AbstractChannelFactory.this.container_.getComponentInstanceOfType(POA.class);
                _poa.destroy(true, false);
            }
        });
        this.config_ = (Configuration)this.container_.getComponentInstanceOfType(Configuration.class);
        this.logger_ = this.config_.getLogger(this.getClass().getName());
        POA _rootPOA = (POA)this.container_.getComponentInstanceOfType(POA.class);
        ArrayList<IdAssignmentPolicy> _ps = new ArrayList<IdAssignmentPolicy>();
        _ps.add(_rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID));
        BiDirGiopPOAComponentAdapter.addBiDirGiopPolicy(_ps, orb, this.config_);
        Policy[] _policies = _ps.toArray(new Policy[_ps.size()]);
        this.eventChannelFactoryPOA_ = _rootPOA.create_POA(EVENTCHANNEL_FACTORY_POA_NAME, _rootPOA.the_POAManager(), _policies);
        for (int x = 0; x < _policies.length; ++x) {
            _policies[x].destroy();
        }
        this.oid_ = this.getObjectName().getBytes();
        this.eventChannelFactoryPOA_.activate_object_with_id(this.oid_, this.getServant());
        this.thisRef_ = this.eventChannelFactoryPOA_.id_to_reference(this.oid_);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("activated EventChannelFactory with OID '" + new String(this.oid_) + "' on '" + this.eventChannelFactoryPOA_.the_name() + "'");
        }
        this.ior_ = orb.object_to_string(this.eventChannelFactoryPOA_.id_to_reference(this.oid_));
        this.corbaLoc_ = "corbaloc:" + CorbaLoc.generateCorbaloc((ORB)orb, (Object)this.eventChannelFactoryPOA_.id_to_servant(this.oid_)._this_object());
        ((org.jacorb.orb.ORB)orb).addObjectKey(this.getShortcut(), this.ior_);
    }

    protected abstract AbstractEventChannel newEventChannel() throws ConfigurationException;

    protected abstract Object create_abstract_channel(Property[] var1, Property[] var2, IntHolder var3) throws UnsupportedAdmin, UnsupportedQoS;

    protected abstract String getObjectName();

    protected abstract String getShortcut();

    protected abstract Servant getServant();

    @Override
    public synchronized Object activate() {
        return this.thisRef_;
    }

    public void setDestroyMethod(Runnable destroyMethod) {
        this.destroyMethod_ = destroyMethod;
    }

    protected ORB getORB() {
        return (ORB)this.container_.getComponentInstance(ORB.class);
    }

    @Override
    public final void deactivate() {
        try {
            this.eventChannelFactoryPOA_.deactivate_object(this.oid_);
        }
        catch (Exception e) {
            this.logger_.error("unable to deactivate object", (Throwable)e);
            throw new RuntimeException();
        }
    }

    protected Configuration getConfiguration() {
        return this.config_;
    }

    public void dispose() {
        try {
            this.unregisterName();
        }
        catch (Exception e) {
            this.logger_.error("unable to unregister NameService registration", (Throwable)e);
        }
        this.deactivate();
        this.channelManager_.dispose();
        this.container_.dispose();
        this.disposableManager_.dispose();
    }

    protected void addToChannels(int id, AbstractEventChannel channel) {
        this.channelManager_.add_channel(id, channel);
    }

    protected int[] getAllChannels() {
        return this.channelManager_.get_all_channels();
    }

    protected AbstractEventChannel get_event_channel_servant(int id) throws ChannelNotFound {
        return this.channelManager_.get_channel_servant(id);
    }

    protected Iterator getChannelIterator() {
        return this.channelManager_.getChannelIterator();
    }

    protected AbstractEventChannel create_channel_servant(IntHolder id, Property[] qosProps, Property[] adminProps) throws UnsupportedAdmin, UnsupportedQoS, ConfigurationException {
        AdminPropertySet _adminSettings = new AdminPropertySet(this.config_);
        _adminSettings.set_admin(adminProps);
        QoSPropertySet _qosSettings = new QoSPropertySet(this.config_, 0);
        _qosSettings.set_qos(qosProps);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("uniqueQoSProps: " + _qosSettings);
            this.logger_.debug("uniqueAdminProps: " + _adminSettings);
        }
        this.checkQoSSettings(_qosSettings);
        AbstractEventChannel _eventChannelServant = this.newEventChannel();
        id.value = _eventChannelServant.getID();
        _eventChannelServant.set_qos(_qosSettings.toArray());
        _eventChannelServant.set_admin(_adminSettings.toArray());
        this.channelCreated(_eventChannelServant);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("created channel_servant id=" + id.value);
        }
        return _eventChannelServant;
    }

    protected void channelCreated(AbstractEventChannel channel) {
    }

    private int createChannelIdentifier() {
        return this.eventChannelIDPool_.getAndIncrement();
    }

    private void checkQoSSettings(PropertySet uniqueQoSProperties) throws UnsupportedQoS {
        if (uniqueQoSProperties.containsKey("EventReliability")) {
            short _eventReliabilty = uniqueQoSProperties.get("EventReliability").extract_short();
            switch (_eventReliabilty) {
                case 0: {
                    this.logger_.info("EventReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("EventReliability");
                }
                default: {
                    this.throwBadValue("EventReliability");
                }
            }
        }
        short _connectionReliability = 0;
        if (uniqueQoSProperties.containsKey("ConnectionReliability")) {
            _connectionReliability = uniqueQoSProperties.get("ConnectionReliability").extract_short();
            switch (_connectionReliability) {
                case 0: {
                    this.logger_.info("ConnectionReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("ConnectionReliability");
                    break;
                }
                default: {
                    this.throwBadValue("ConnectionReliability");
                }
            }
        }
    }

    private void throwPersistentNotSupported(String property) throws UnsupportedQoS {
        Any _lowVal = this.getORB().create_any();
        Any _highVal = this.getORB().create_any();
        _lowVal.insert_short((short)0);
        _highVal.insert_short((short)0);
        UnsupportedQoS _e = new UnsupportedQoS(new PropertyError[]{new PropertyError(QoSError_code.UNSUPPORTED_VALUE, property, new PropertyRange(_lowVal, _highVal))});
        throw _e;
    }

    private void throwBadValue(String property) throws UnsupportedQoS {
        Any _lowVal = this.getORB().create_any();
        Any _highVal = this.getORB().create_any();
        _lowVal.insert_short((short)0);
        _highVal.insert_short((short)0);
        UnsupportedQoS _e = new UnsupportedQoS("The specified Property Value is not supported", new PropertyError[]{new PropertyError(QoSError_code.BAD_VALUE, property, new PropertyRange(_lowVal, _highVal))});
        throw _e;
    }

    public void destroy() {
        Thread _shutdown = new Thread(){

            @Override
            public void run() {
                try {
                    AbstractChannelFactory.this.logger_.info("Notification Service is going down in 1000 ms");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AbstractChannelFactory.this.destroyMethod_.run();
            }
        };
        _shutdown.start();
    }

    public void shutdown(ShutdownCallback cb) {
        int _numberOfClients = 0;
        Iterator i = this.getChannelIterator();
        while (i.hasNext()) {
            AbstractEventChannel _channel = (AbstractEventChannel)((Map.Entry)i.next()).getValue();
            _numberOfClients += _channel.getNumberOfConnectedClients();
        }
        int _connectionTimeout = 4000;
        int _estimatedShutdowntime = 2000 + _numberOfClients * _connectionTimeout;
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Connected Clients: " + _numberOfClients);
            this.logger_.info("Connection Timeout: " + _connectionTimeout + " ms");
            this.logger_.info("Estimated Shutdowntime: " + _estimatedShutdowntime + " ms");
        }
        cb.needTime(_estimatedShutdowntime);
        this.logger_.info("NotificationService is going down");
        this.destroyMethod_.run();
        this.logger_.info("NotificationService down");
        cb.shutdownComplete();
    }

    public String getIOR() {
        return this.ior_;
    }

    public String getCorbaLoc() {
        return this.corbaLoc_;
    }

    private static AbstractChannelFactory newChannelFactory(MutablePicoContainer container, ORB orb, boolean typed) throws UserException {
        if (typed) {
            return new TypedEventChannelFactoryImpl(container, orb);
        }
        return new EventChannelFactoryImpl(container, orb);
    }

    private static AbstractChannelFactory newFactory(MutablePicoContainer container, final ORB orb, boolean startThread, Properties props) throws Exception {
        AbstractChannelFactory _factory = AbstractChannelFactory.newChannelFactory(container, orb, "on".equals(props.get("jacorb.notification.enable_typed_channel")));
        _factory.activate();
        _factory.printIOR(props);
        _factory.printCorbaLoc(props);
        _factory.writeIOR(props);
        _factory.registerName(props);
        _factory.startChannels(props);
        if (startThread) {
            POA _poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            _poa.the_POAManager().activate();
            Thread _orbThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    orb.run();
                }
            });
            _orbThread.setName("Notification ORB Runner Thread");
            _orbThread.setDaemon(false);
            _orbThread.start();
            _factory.disposableManager_.addDisposable(new Disposable(){

                public void dispose() {
                    orb.shutdown(false);
                }
            });
        }
        return _factory;
    }

    public static AbstractChannelFactory newFactory(ORB optionalORB, MutablePicoContainer optionalContainer, Properties props) throws Exception {
        props.put("jacorb.implname", STANDARD_IMPL_NAME);
        ORB _orb = optionalORB != null ? optionalORB : ORB.init((String[])new String[0], (Properties)props);
        AbstractChannelFactory factory = AbstractChannelFactory.newFactory(optionalContainer, _orb, optionalORB == null, props);
        return factory;
    }

    public static AbstractChannelFactory newFactory(Properties props) throws Exception {
        return AbstractChannelFactory.newFactory(null, null, props);
    }

    public void registerName(Properties props) throws Exception {
        this.registerName(props.getProperty("jacorb.notification.register_name.id", null), props.getProperty("jacorb.notification.register_name.kind", ""));
    }

    public synchronized void registerName(String nameId, String nameKind) throws NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName {
        if (nameId == null) {
            return;
        }
        this.namingContext_ = NamingContextHelper.narrow((Object)this.getORB().resolve_initial_references("NameService"));
        NameComponent[] _name = new NameComponent[]{new NameComponent(nameId, nameKind)};
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("namingContext.rebind(" + AbstractChannelFactory.format(_name) + " => " + this.getCorbaLoc() + ")");
        }
        this.namingContext_.rebind(_name, this.thisRef_);
        this.registeredName_ = _name;
    }

    public synchronized void unregisterName() throws NotFound, CannotProceed, InvalidName {
        if (this.namingContext_ != null && this.registeredName_ != null) {
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info("namingContext.unbind(" + AbstractChannelFactory.format(this.registeredName_) + ")");
            }
            this.namingContext_.unbind(this.registeredName_);
            this.registeredName_ = null;
        }
    }

    private static String format(NameComponent[] name) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < name.length; ++i) {
            if (i != 0) {
                b.append('/');
            }
            AbstractChannelFactory.format(name[i], b);
        }
        return b.toString();
    }

    private static void format(NameComponent name, StringBuffer b) {
        b.append(name.id);
        if (name.kind != null) {
            b.append('.');
            b.append(name.kind);
        }
    }

    private void startChannels(Properties props) throws UnsupportedQoS, UnsupportedAdmin {
        if (props.containsKey("jacorb.notification.start_channels")) {
            this.startChannels(Integer.parseInt((String)props.get("jacorb.notification.start_channels")));
        }
    }

    private void startChannels(int channels) throws UnsupportedQoS, UnsupportedAdmin {
        for (int i = 0; i < channels; ++i) {
            IntHolder ih = new IntHolder();
            this.create_abstract_channel(new Property[0], new Property[0], ih);
        }
    }

    private void printIOR(Properties props) {
        if ("on".equals(props.get("jacorb.notification.print_ior"))) {
            System.out.println(this.getIOR());
        }
    }

    private void printCorbaLoc(Properties props) {
        if ("on".equals(props.get("jacorb.notification.print_corbaloc"))) {
            System.out.println(this.getCorbaLoc());
        }
    }

    private void writeIOR(Properties props) throws IOException {
        String _iorFileName = (String)props.get("jacorb.notification.ior_file");
        if (_iorFileName != null) {
            this.writeIOR(_iorFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIOR(String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        try {
            this.writeIOR(out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    private void writeIOR(Writer out) {
        PrintWriter writer = new PrintWriter(out);
        writer.println(this.getIOR());
    }

    public POA _default_POA() {
        return this.eventChannelFactoryPOA_;
    }

    protected MutablePicoContainer newContainerForChannel() {
        final MutablePicoContainer _channelContainer = PicoContainerFactory.createChildContainer(this.container_);
        final int _channelID = this.createChannelIdentifier();
        IFactory _factory = new IFactory(){

            @Override
            public MutablePicoContainer getContainer() {
                return _channelContainer;
            }

            @Override
            public int getChannelID() {
                return _channelID;
            }

            @Override
            public void destroy() {
                AbstractChannelFactory.this.container_.removeChildContainer((PicoContainer)_channelContainer);
            }
        };
        _channelContainer.registerComponentInstance(IFactory.class, (java.lang.Object)_factory);
        return _channelContainer;
    }

    static interface ShutdownCallback {
        public void needTime(int var1);

        public void shutdownComplete();
    }
}

