/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IProxyConsumer;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.jacorb.notification.servant.ProxyPullConsumerImplMBean;
import org.jacorb.notification.servant.PullMessagesOperation;
import org.jacorb.notification.servant.PullMessagesUtility;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PullSupplier;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class ProxyPullConsumerImpl
extends AbstractProxyConsumer
implements ProxyPullConsumerOperations,
MessageSupplier,
MessageSupplierDelegate,
ProxyPullConsumerImplMBean {
    private PullSupplier pullSupplier_;
    private long pollInterval_;
    private final PullMessagesOperation pullMessagesOperation_;
    private final PullMessagesUtility pollTaskUtility_;

    public ProxyPullConsumerImpl(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(admin, orb, poa, conf, taskProcessor, messageFactory, null, offerManager, subscriptionManager);
        try {
            this.pollInterval_ = conf.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
        }
        catch (ConfigurationException ex) {
            this.logger_.error("Error configuring ProxyPullConsumerImpl ", (Throwable)ex);
            throw new INTERNAL("Error configuring ProxyPullConsumerImpl " + (Object)((Object)ex));
        }
        this.pullMessagesOperation_ = new PullMessagesOperation(this);
        this.pollTaskUtility_ = new PullMessagesUtility(taskProcessor, this);
    }

    @Override
    public ProxyType MyType() {
        return ProxyType.PULL_ANY;
    }

    @Override
    public void disconnect_pull_consumer() {
        this.destroy();
    }

    @Override
    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_pull_supplier();
        this.pullSupplier_ = null;
    }

    @Override
    protected void connectionSuspended() {
        this.stopTask();
    }

    @Override
    protected void connectionResumed() {
        this.startTask();
    }

    @Override
    public void runPullMessage() throws Disconnected {
        this.pullMessagesOperation_.runPull();
    }

    @Override
    public void connect_any_pull_supplier(PullSupplier pullSupplier) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.pullSupplier_ = pullSupplier;
        this.connectClient(pullSupplier);
        this.startTask();
    }

    private synchronized void startTask() {
        this.pollTaskUtility_.startTask(this.pollInterval_);
    }

    private synchronized void stopTask() {
        this.pollTaskUtility_.stopTask();
    }

    @Override
    public Servant newServant() {
        return new ProxyPullConsumerPOATie(this);
    }

    public long getPollInterval() {
        return this.pollInterval_;
    }

    public long getPullTimer() {
        return this.pullMessagesOperation_.getTimeSpentInPull();
    }

    public int getPullCounter() {
        return this.pullMessagesOperation_.getPullCounter();
    }

    public int getSuccessfulPullCounter() {
        return this.pullMessagesOperation_.getSuccessfulPullCounter();
    }

    @Override
    public MessageSupplierDelegate.PullResult pullMessages() throws Disconnected {
        BooleanHolder _hasEvent = new BooleanHolder();
        Any _event = this.pullSupplier_.try_pull(_hasEvent);
        return new MessageSupplierDelegate.PullResult(_event, _hasEvent.value);
    }

    @Override
    public void queueMessages(MessageSupplierDelegate.PullResult data) {
        Message _message = this.getMessageFactory().newMessage((Any)data.data_, (IProxyConsumer)this);
        this.checkMessageProperties(_message);
        this.processMessage(_message);
    }
}

