/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.spring;

import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.verticle.CompilingClassLoader;
import io.vertx.core.spi.VerticleFactory;
import org.jacpfx.vertx.spring.SpringContextConfiguration;
import org.jacpfx.vertx.spring.SpringSingleVerticleConfiguration;
import org.jacpfx.vertx.spring.SpringVerticle;
import org.jacpfx.vertx.spring.VerticleBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class SpringVerticleFactory
implements VerticleFactory {
    private Vertx vertx;
    public static final String PREFIX = "java-spring";
    public static final String SUFFIX = ".java";
    private static GenericApplicationContext parentContext = null;

    public String prefix() {
        return PREFIX;
    }

    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    public synchronized Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        Class clazz;
        String className = VerticleFactory.removePrefix((String)verticleName);
        if (className.endsWith(SUFFIX)) {
            CompilingClassLoader compilingLoader = new CompilingClassLoader(classLoader, className);
            clazz = compilingLoader.loadClass(compilingLoader.resolveMainClassName());
        } else {
            clazz = classLoader.loadClass(className);
        }
        return this.createVerticle(clazz, classLoader);
    }

    private Verticle createVerticle(Class<?> clazz, ClassLoader classLoader) throws Exception {
        if (clazz.isAnnotationPresent(SpringVerticle.class)) {
            return this.createSpringVerticle(clazz, classLoader);
        }
        if (Verticle.class.isAssignableFrom(clazz)) {
            Verticle verticle = (Verticle)Verticle.class.cast(clazz.newInstance());
            verticle.init(this.vertx, this.vertx.getOrCreateContext());
            return verticle;
        }
        return null;
    }

    private Verticle createSpringVerticle(Class<?> currentVerticleClass, ClassLoader classLoader) {
        SpringVerticle annotation = currentVerticleClass.getAnnotation(SpringVerticle.class);
        Class<?> springConfigClass = annotation.springConfig();
        GenericApplicationContext genericApplicationContext = new GenericApplicationContext();
        genericApplicationContext.setClassLoader(classLoader);
        if (parentContext != null) {
            genericApplicationContext.setParent((ApplicationContext)parentContext);
        }
        genericApplicationContext.refresh();
        genericApplicationContext.start();
        AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext();
        annotationConfigApplicationContext.setParent((ApplicationContext)genericApplicationContext);
        annotationConfigApplicationContext.register(new Class[]{SpringContextConfiguration.class, springConfigClass});
        annotationConfigApplicationContext.registerBeanDefinition(currentVerticleClass.getSimpleName(), (BeanDefinition)new VerticleBeanDefinition(currentVerticleClass));
        annotationConfigApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new SpringSingleVerticleConfiguration(currentVerticleClass));
        annotationConfigApplicationContext.refresh();
        annotationConfigApplicationContext.start();
        annotationConfigApplicationContext.registerShutdownHook();
        return (Verticle)annotationConfigApplicationContext.getBeanFactory().getBean(currentVerticleClass.getSimpleName());
    }

    public void close() {
    }

    public static void setParentContext(GenericApplicationContext ctx) {
        parentContext = ctx;
    }
}

