/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.spring;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.jacpfx.vertx.spring.SpringVerticle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

@Aspect
public class VertxLifecycleAspect {
    private static final Logger log = LoggerFactory.getLogger(VertxLifecycleAspect.class);
    @Autowired
    public ApplicationContext context;

    @After(value="execution(* io.vertx.core.Verticle+.stop())")
    public void afterStop(JoinPoint joinPoint) {
        Object target = joinPoint.getTarget();
        log.debug((Object)"Stop invoked - Terminating spring context for verticle");
        if (target.getClass().isAnnotationPresent(SpringVerticle.class) && AnnotationConfigApplicationContext.class.isAssignableFrom(this.context.getClass())) {
            ApplicationContext parent = ((AnnotationConfigApplicationContext)AnnotationConfigApplicationContext.class.cast(this.context)).getParent();
            if (parent == null) {
                ((AnnotationConfigApplicationContext)AnnotationConfigApplicationContext.class.cast(this.context)).stop();
            } else if (GenericApplicationContext.class.isAssignableFrom(parent.getClass())) {
                ((GenericApplicationContext)GenericApplicationContext.class.cast(parent)).stop();
            }
        }
    }

    @After(value="execution(* io.vertx.core.Verticle+.start(..))")
    public void afterStart(JoinPoint joinPoint) {
        log.debug((Object)"START spring verticle");
    }
}

