/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.spring;

import java.util.ArrayList;
import java.util.List;
import org.jacpfx.vertx.spring.SpringVerticle;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class SpringSingleVerticleConfiguration
implements BeanFactoryPostProcessor {
    private final Class<?> currentSpringVerticleClass;

    public SpringSingleVerticleConfiguration(Class<?> currentSpringVerticleClass) {
        this.currentSpringVerticleClass = currentSpringVerticleClass;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] verticleBeanNames;
        SpringVerticle annotation = this.currentSpringVerticleClass.getAnnotation(SpringVerticle.class);
        if (annotation.autoremoveOtherSpringVerticles() && (verticleBeanNames = beanFactory.getBeanNamesForAnnotation(SpringVerticle.class)).length > 1) {
            List<String> beansToRemove = this.getBeanNamesToRemove(verticleBeanNames, beanFactory);
            beansToRemove.forEach(arg_0 -> ((BeanDefinitionRegistry)((BeanDefinitionRegistry)beanFactory)).removeBeanDefinition(arg_0));
        }
    }

    private List<String> getBeanNamesToRemove(String[] verticleBeanNames, ConfigurableListableBeanFactory beanFactory) {
        ArrayList<String> beansToRemove = new ArrayList<String>();
        for (String name : verticleBeanNames) {
            Class verticleClass = beanFactory.getType(name);
            if (this.currentSpringVerticleClass.equals(verticleClass)) continue;
            beansToRemove.add(name);
        }
        return beansToRemove;
    }
}

