/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jacpfx.common.util.ConfigurationUtil;
import org.jacpfx.common.util.URIUtil;
import org.jacpfx.vertx.event.annotation.Consume;
import org.jacpfx.vertx.event.annotation.OnEventError;
import org.jacpfx.vertx.event.response.EventbusHandler;
import org.jacpfx.vertx.event.util.ReflectionUtil;

public class EventInitializer {
    public static final String ROOT = "/";
    public static final String HTTP_ALL = "ALL";
    public static final String EVENTBUS = "eventbus";

    public static void initEventbusHandling(Vertx vertx, Object service) {
        Stream.of(service.getClass().getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Consume.class)).forEach(restMethod -> EventInitializer.initEventbusMethod(vertx, service, restMethod));
    }

    public static void initEventbusMethod(Vertx vertx, Object service, Method eventBusMethod) {
        Consume path = eventBusMethod.getAnnotation(Consume.class);
        Optional<Method> errorMethod = EventInitializer.getEventbusMethods(service, path.value()).stream().filter(method -> method.isAnnotationPresent(OnEventError.class)).findFirst();
        Optional.ofNullable(path).ifPresent(g -> EventInitializer.initCallback(vertx, service, eventBusMethod, path, errorMethod));
    }

    protected static void initCallback(Vertx vertx, Object service, Method eventBusMethod, Consume path, Optional<Method> errorMethod) {
        String contexRoot = URIUtil.getCleanContextRoot((String)ConfigurationUtil.getContextRoot((JsonObject)vertx.getOrCreateContext().config(), service.getClass()));
        String route = contexRoot + URIUtil.cleanPath((String)path.value());
        Context context = vertx.getOrCreateContext();
        String methodId = path.value() + EVENTBUS + ConfigurationUtil.getCircuitBreakerIDPostfix((JsonObject)context.config());
        EventInitializer.registerCallback(methodId, route, vertx, service, eventBusMethod, errorMethod);
    }

    private static void registerCallback(String methodId, String route, Vertx vertx, Object service, Method eventBusMethod, Optional<Method> errorMethod) {
        vertx.eventBus().consumer(route, eventbusHandler -> EventInitializer.handleIncomingEvent(methodId, vertx, service, eventBusMethod, errorMethod, (Message<Object>)eventbusHandler));
    }

    private static void handleIncomingEvent(String methodId, Vertx vertx, Object service, Method restMethod, Optional<Method> onErrorMethod, Message<Object> eventbusHandler) {
        try {
            Object[] parameters = EventInitializer.getInvocationParameters(methodId, vertx, service, restMethod, onErrorMethod, eventbusHandler);
            ReflectionUtil.genericMethodInvocation(restMethod, () -> parameters, service);
        }
        catch (Throwable throwable) {
            EventInitializer.handleEventBusError(methodId + "ERROR", vertx, service, onErrorMethod, eventbusHandler, throwable);
        }
    }

    private static List<Method> getEventbusMethods(Object service, String sName) {
        String methodName = sName;
        Method[] declaredMethods = service.getClass().getDeclaredMethods();
        return Stream.of(declaredMethods).filter(method -> EventInitializer.filterEventbusMethods(method, methodName)).collect(Collectors.toList());
    }

    private static boolean filterEventbusMethods(Method method, String methodName) {
        return method.isAnnotationPresent(Consume.class) && method.getAnnotation(Consume.class).value().equalsIgnoreCase(methodName) || method.isAnnotationPresent(OnEventError.class) && method.getAnnotation(OnEventError.class).value().equalsIgnoreCase(methodName);
    }

    private static Object[] getInvocationParameters(String methodId, Vertx vertx, Object service, Method restMethod, Optional<Method> onErrorMethod, Message<Object> eventbusHandler) {
        Consumer<Throwable> throwableConsumer = throwable -> EventInitializer.handleEventBusError(methodId + "ERROR", vertx, service, onErrorMethod, eventbusHandler, throwable);
        return ReflectionUtil.invokeParameters(restMethod, null, new EventbusHandler(methodId, eventbusHandler, vertx, null, throwableConsumer));
    }

    private static void handleEventBusError(String methodId, Vertx vertx, Object service, Optional<Method> onErrorMethod, Message<Object> eventbusHandler, Throwable throwable) {
        if (onErrorMethod.isPresent()) {
            EventInitializer.invokeOnErrorMethod(methodId, vertx, service, onErrorMethod, eventbusHandler, throwable);
        } else {
            EventInitializer.failRequest(eventbusHandler, throwable);
        }
    }

    private static void invokeOnErrorMethod(String methodId, Vertx vertx, Object service, Optional<Method> onErrorMethod, Message<Object> eventbusHandler, Throwable throwable) {
        onErrorMethod.ifPresent(errorMethod -> {
            try {
                ReflectionUtil.genericMethodInvocation(errorMethod, () -> ReflectionUtil.invokeParameters(errorMethod, throwable, new EventbusHandler(methodId, eventbusHandler, vertx, throwable, null)), service);
            }
            catch (Throwable t) {
                EventInitializer.failRequest(eventbusHandler, t);
            }
        });
    }

    private static void failRequest(Message<Object> eventbusHandler, Throwable throwable) {
        eventbusHandler.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), throwable.getMessage());
        throwable.printStackTrace();
    }
}

