/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.eventbus.basic;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.common.encoder.Encoder;
import org.jacpfx.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.common.throwable.ThrowableFutureBiConsumer;
import org.jacpfx.common.throwable.ThrowableFutureConsumer;
import org.jacpfx.vertx.event.interfaces.basic.RecursiveExecutor;
import org.jacpfx.vertx.event.interfaces.basic.RetryExecutor;
import org.jacpfx.vertx.event.response.basic.ResponseExecution;

public class EventbusBridgeExecution {
    public static final long LOCK_VALUE = -1L;
    public static final int DEFAULT_LOCK_TIMEOUT = 2000;
    public static final long NO_TIMEOUT = 0L;

    public static <T> void sendMessageAndSupplyHandler(String methodId, String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> function, DeliveryOptions requestDeliveryOptions, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retryExecutor) {
        if (circuitBreakerTimeout == 0L) {
            EventbusBridgeExecution.executeDefaultState(targetId, message, function, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retryExecutor, null);
        } else {
            EventbusBridgeExecution.executeStateful(targetId, message, function, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retryExecutor);
        }
    }

    private static <T> void executeStateful(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry) {
        EventbusBridgeExecution.executeLocked((lock, counter) -> counter.get(counterHandler -> {
            long currentVal = (Long)counterHandler.result();
            if (currentVal == 0L) {
                EventbusBridgeExecution.executeInitialState(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, lock, counter);
            } else if (currentVal > 0L) {
                EventbusBridgeExecution.executeDefaultState(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, lock);
            } else {
                EventbusBridgeExecution.executeErrorState(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, lock);
            }
        }), methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor);
    }

    private static <T> void executeInitialState(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry, Lock lock, Counter counter) {
        int incrementCounter = retryCount + 1;
        counter.addAndGet(Integer.valueOf(incrementCounter).longValue(), rHandler -> EventbusBridgeExecution.executeDefaultState(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, lock));
    }

    private static <T> void executeDefaultState(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry, Lock lock) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        vertx.eventBus().send(targetId, message, requestDeliveryOptions, event -> EventbusBridgeExecution.createSupplierAndExecute(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, (AsyncResult<Message<Object>>)event));
    }

    private static <T> void executeErrorState(String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, Lock lock) {
        Throwable cause = Future.failedFuture((String)"circuit open").cause();
        EventbusBridgeExecution.handleError(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, lock, cause);
    }

    private static <T> void createSupplierAndExecute(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry, AsyncResult<Message<Object>> event) {
        ThrowableFutureConsumer<T> objectConsumer = EventbusBridgeExecution.createSupplier(objectFunction, event);
        if (circuitBreakerTimeout == 0L) {
            EventbusBridgeExecution.statelessExecution(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, event, objectConsumer);
        } else {
            EventbusBridgeExecution.statefulExecution(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, event, objectConsumer);
        }
    }

    private static <T> void statelessExecution(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry, AsyncResult<Message<Object>> event, ThrowableFutureConsumer<T> objectConsumer) {
        if (!event.failed() || event.failed() && retryCount <= 0) {
            executor.execute(methodId, vertx, event.cause(), errorMethodHandler, requestMessage, objectConsumer, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout);
        } else if (event.failed() && retryCount > 0) {
            EventbusBridgeExecution.retryFunction(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, event.cause(), errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, retry);
        }
    }

    private static <T> void statefulExecution(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry, AsyncResult<Message<Object>> event, ThrowableFutureConsumer<T> objectConsumer) {
        if (event.succeeded()) {
            executor.execute(methodId, vertx, event.cause(), errorMethodHandler, requestMessage, objectConsumer, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout);
        } else {
            EventbusBridgeExecution.statefulErrorHandling(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, event.cause(), errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, retry, event);
        }
    }

    private static <T> void statefulErrorHandling(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Throwable t, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, RetryExecutor retry, AsyncResult<Message<Object>> event) {
        EventbusBridgeExecution.executeLocked((lock, counter) -> EventbusBridgeExecution.decrementAndExecute(counter, (Handler<AsyncResult<Long>>)((Handler)valHandler -> {
            if (valHandler.succeeded()) {
                long count = (Long)valHandler.result();
                if (count <= 0L) {
                    EventbusBridgeExecution.openCircuitAndHandleError(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, event, lock, counter);
                } else {
                    lock.release();
                    EventbusBridgeExecution.retryFunction(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, t, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, retry);
                }
            } else {
                Throwable cause = valHandler.cause();
                EventbusBridgeExecution.handleError(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, lock, cause);
            }
        })), methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor);
    }

    private static void decrementAndExecute(Counter counter, Handler<AsyncResult<Long>> asyncResultHandler) {
        counter.decrementAndGet(asyncResultHandler);
    }

    private static <T> void executeLocked(LockedConsumer consumer, String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor) {
        SharedData sharedData = vertx.sharedData();
        sharedData.getLockWithTimeout(methodId, 2000L, lockHandler -> {
            if (lockHandler.succeeded()) {
                Lock lock = (Lock)lockHandler.result();
                sharedData.getCounter(methodId, resultHandler -> {
                    if (resultHandler.succeeded()) {
                        consumer.execute(lock, (Counter)resultHandler.result());
                    } else {
                        Throwable cause = resultHandler.cause();
                        EventbusBridgeExecution.handleError(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, lock, cause);
                    }
                });
            } else {
                Throwable cause = lockHandler.cause();
                EventbusBridgeExecution.handleError(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, null, cause);
            }
        });
    }

    private static <T> void openCircuitAndHandleError(String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, AsyncResult<Message<Object>> event, Lock lock, Counter counter) {
        EventbusBridgeExecution.resetLockTimer(vertx, retryCount, circuitBreakerTimeout, counter);
        EventbusBridgeExecution.lockAndHandle(counter, (Handler<AsyncResult<Long>>)((Handler)val -> {
            Throwable cause = event.cause();
            EventbusBridgeExecution.handleError(methodId, vertx, errorMethodHandler, requestMessage, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout, executor, lock, cause);
        }));
    }

    private static void lockAndHandle(Counter counter, Handler<AsyncResult<Long>> asyncResultHandler) {
        counter.addAndGet(-1L, asyncResultHandler);
    }

    private static void resetLockTimer(Vertx vertx, int retryCount, long circuitBreakerTimeout, Counter counter) {
        vertx.setTimer(circuitBreakerTimeout, timer -> counter.addAndGet(Integer.valueOf(retryCount + 1).longValue(), val -> {}));
    }

    private static <T> void handleError(String methodId, Vertx vertx, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RecursiveExecutor executor, Lock lock, Throwable cause) {
        Optional.ofNullable(lock).ifPresent(Lock::release);
        ThrowableFutureConsumer failConsumer = future -> future.fail(cause);
        executor.execute(methodId, vertx, cause, errorMethodHandler, requestMessage, failConsumer, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout);
    }

    private static <T> void retryFunction(String targetId, Object message, ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, DeliveryOptions requestDeliveryOptions, String methodId, Vertx vertx, Throwable t, Consumer<Throwable> errorMethodHandler, Message<Object> requestMessage, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, T> onFailureRespond, DeliveryOptions responseDeliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout, RetryExecutor retry) {
        ResponseExecution.handleError(errorHandler, t);
        retry.execute(targetId, message, objectFunction, requestDeliveryOptions, methodId, vertx, t, errorMethodHandler, requestMessage, null, encoder, errorHandler, onFailureRespond, responseDeliveryOptions, retryCount, timeout, circuitBreakerTimeout);
    }

    private static <T> ThrowableFutureConsumer<T> createSupplier(ThrowableFutureBiConsumer<AsyncResult<Message<Object>>, T> objectFunction, AsyncResult<Message<Object>> event) {
        return future -> {
            if (event.failed()) {
                future.fail(event.cause());
            } else {
                objectFunction.accept((Object)event, future);
            }
        };
    }

    private static interface LockedConsumer {
        public void execute(Lock var1, Counter var2);
    }
}

