/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.response;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import java.io.Serializable;
import java.util.function.Consumer;
import org.jacpfx.common.encoder.Encoder;
import org.jacpfx.common.throwable.ThrowableFutureConsumer;
import org.jacpfx.vertx.event.response.EventbusResponseBlocking;
import org.jacpfx.vertx.event.response.basic.ExecuteEventbusBasicByteResponse;
import org.jacpfx.vertx.event.response.basic.ExecuteEventbusBasicObjectResponse;
import org.jacpfx.vertx.event.response.basic.ExecuteEventbusBasicStringResponse;

public class EventbusResponse {
    private final String methodId;
    private final Vertx vertx;
    private final Throwable failure;
    private final Consumer<Throwable> errorMethodHandler;
    private final Message<Object> message;

    public EventbusResponse(String methodId, Message<Object> message, Vertx vertx, Throwable failure, Consumer<Throwable> errorMethodHandler) {
        this.methodId = methodId;
        this.vertx = vertx;
        this.failure = failure;
        this.errorMethodHandler = errorMethodHandler;
        this.message = message;
    }

    public EventbusResponseBlocking blocking() {
        return new EventbusResponseBlocking(this.methodId, this.message, this.vertx, this.failure, this.errorMethodHandler);
    }

    public ExecuteEventbusBasicByteResponse byteResponse(ThrowableFutureConsumer<byte[]> byteConsumer) {
        return new ExecuteEventbusBasicByteResponse(this.methodId, this.vertx, this.failure, this.errorMethodHandler, this.message, byteConsumer, null, null, null, null, 0, 0L, 0L);
    }

    public ExecuteEventbusBasicStringResponse stringResponse(ThrowableFutureConsumer<String> stringConsumer) {
        return new ExecuteEventbusBasicStringResponse(this.methodId, this.vertx, this.failure, this.errorMethodHandler, this.message, stringConsumer, null, null, null, null, 0, 0L, 0L);
    }

    public ExecuteEventbusBasicObjectResponse objectResponse(ThrowableFutureConsumer<Serializable> objectConsumer, Encoder encoder) {
        return new ExecuteEventbusBasicObjectResponse(this.methodId, this.vertx, this.failure, this.errorMethodHandler, this.message, objectConsumer, null, encoder, null, null, null, 0, 0L, 0L);
    }
}

