/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.response.basic;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.common.throwable.ThrowableErrorConsumer;
import org.jacpfx.common.throwable.ThrowableFutureConsumer;
import org.jacpfx.vertx.event.interfaces.basic.ExecuteEventbusByteCall;
import org.jacpfx.vertx.event.response.basic.ResponseExecution;

public class ExecuteEventbusBasicByte {
    protected final String methodId;
    protected final Vertx vertx;
    protected final Throwable failure;
    protected final Message<Object> message;
    protected final Consumer<Throwable> errorHandler;
    protected final Consumer<Throwable> errorMethodHandler;
    protected final ThrowableFutureConsumer<byte[]> byteConsumer;
    protected final ThrowableErrorConsumer<Throwable, byte[]> onFailureRespond;
    protected final ExecuteEventbusByteCall excecuteEventBusAndReply;
    protected final DeliveryOptions deliveryOptions;
    protected final int retryCount;
    protected final long timeout;
    protected final long circuitBreakerTimeout;

    public ExecuteEventbusBasicByte(String methodId, Vertx vertx, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> message, ThrowableFutureConsumer<byte[]> byteConsumer, ExecuteEventbusByteCall excecuteEventBusAndReply, Consumer<Throwable> errorHandler, ThrowableErrorConsumer<Throwable, byte[]> onFailureRespond, DeliveryOptions deliveryOptions, int retryCount, long timeout, long circuitBreakerTimeout) {
        this.methodId = methodId;
        this.vertx = vertx;
        this.failure = failure;
        this.errorMethodHandler = errorMethodHandler;
        this.message = message;
        this.byteConsumer = byteConsumer;
        this.errorHandler = errorHandler;
        this.onFailureRespond = onFailureRespond;
        this.deliveryOptions = deliveryOptions;
        this.retryCount = retryCount;
        this.excecuteEventBusAndReply = excecuteEventBusAndReply;
        this.timeout = timeout;
        this.circuitBreakerTimeout = circuitBreakerTimeout;
    }

    public void execute(DeliveryOptions deliveryOptions) {
        Objects.requireNonNull(deliveryOptions);
        new ExecuteEventbusBasicByte(this.methodId, this.vertx, this.failure, this.errorMethodHandler, this.message, this.byteConsumer, this.excecuteEventBusAndReply, this.errorHandler, this.onFailureRespond, deliveryOptions, this.retryCount, this.timeout, this.circuitBreakerTimeout).execute();
    }

    public void execute() {
        this.vertx.runOnContext(action -> {
            Optional.ofNullable(this.excecuteEventBusAndReply).ifPresent(evFunction -> {
                try {
                    evFunction.execute(this.methodId, this.vertx, this.errorMethodHandler, this.message, this.errorHandler, this.onFailureRespond, this.deliveryOptions, this.retryCount, this.timeout, this.circuitBreakerTimeout);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            Optional.ofNullable(this.byteConsumer).ifPresent(userOperation -> {
                int retry = this.retryCount;
                ResponseExecution.createResponse(this.methodId, retry, this.timeout, this.circuitBreakerTimeout, userOperation, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vertx, this.failure, value -> {
                    if (value.succeeded()) {
                        this.respond((byte[])value.getResult());
                    } else {
                        this.fail(value.getCause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                    }
                });
            });
        });
    }

    protected void fail(String result, int statuscode) {
        if (result != null) {
            this.message.fail(statuscode, result);
        }
    }

    protected void respond(byte[] result) {
        if (result != null) {
            if (this.deliveryOptions != null) {
                this.message.reply((Object)result, this.deliveryOptions);
            } else {
                this.message.reply((Object)result);
            }
        }
    }
}

