/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.response.blocking;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.common.ExecutionResult;
import org.jacpfx.common.encoder.Encoder;
import org.jacpfx.common.throwable.ThrowableFunction;
import org.jacpfx.common.throwable.ThrowableSupplier;
import org.jacpfx.vertx.event.interfaces.blocking.ExecuteEventbusObjectCallBlocking;
import org.jacpfx.vertx.event.response.basic.ExecuteEventbusBasicObject;
import org.jacpfx.vertx.event.response.blocking.ResponseBlockingExecution;

public class ExecuteEventbusObject
extends ExecuteEventbusBasicObject {
    protected final long delay;
    protected final long timeout;
    protected final ExecuteEventbusObjectCallBlocking excecuteEventBusAndReply;
    protected final ThrowableSupplier<Serializable> objectSupplier;
    protected final ThrowableFunction<Throwable, Serializable> onFailureRespond;

    public ExecuteEventbusObject(String methodId, Vertx vertx, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> message, ThrowableSupplier<Serializable> objectSupplier, ExecuteEventbusObjectCallBlocking excecuteEventBusAndReply, Encoder encoder, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, Serializable> onFailureRespond, DeliveryOptions deliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout) {
        super(methodId, vertx, failure, errorMethodHandler, message, null, null, encoder, errorHandler, null, deliveryOptions, retryCount, timeout, circuitBreakerTimeout);
        this.delay = delay;
        this.timeout = timeout;
        this.excecuteEventBusAndReply = excecuteEventBusAndReply;
        this.objectSupplier = objectSupplier;
        this.onFailureRespond = onFailureRespond;
    }

    @Override
    public void execute(DeliveryOptions deliveryOptions) {
        Objects.requireNonNull(deliveryOptions);
        new ExecuteEventbusObject(this.methodId, this.vertx, this.failure, this.errorMethodHandler, (Message<Object>)this.message, this.objectSupplier, this.excecuteEventBusAndReply, this.encoder, this.errorHandler, this.onFailureRespond, deliveryOptions, this.retryCount, this.delay, this.timeout, this.circuitBreakerTimeout).execute();
    }

    @Override
    public void execute() {
        Optional.ofNullable(this.excecuteEventBusAndReply).ifPresent(evFunction -> {
            try {
                evFunction.execute(this.methodId, this.vertx, this.errorMethodHandler, (Message<Object>)this.message, this.encoder, this.errorHandler, this.onFailureRespond, this.deliveryOptions, this.retryCount, this.timeout, this.delay, this.circuitBreakerTimeout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Optional.ofNullable(this.objectSupplier).ifPresent(supplier -> {
            int retry = this.retryCount;
            this.vertx.executeBlocking(handler -> this.executeAsync((ThrowableSupplier<Serializable>)supplier, retry, (Future<ExecutionResult<Serializable>>)handler), false, this.getAsyncResultHandler(retry));
        });
    }

    private void executeAsync(ThrowableSupplier<Serializable> supplier, int retry, Future<ExecutionResult<Serializable>> handler) {
        ResponseBlockingExecution.createResponseBlocking(this.methodId, supplier, handler, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vertx, this.failure, retry, this.timeout, this.circuitBreakerTimeout, this.delay);
    }

    private Handler<AsyncResult<ExecutionResult<Serializable>>> getAsyncResultHandler(int retry) {
        return value -> {
            if (!value.failed()) {
                this.respond((Serializable)((ExecutionResult)value.result()).getResult());
            } else if (retry == 0) {
                this.fail(value.cause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        };
    }
}

