/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.vertx.event.response.blocking;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jacpfx.common.ExecutionResult;
import org.jacpfx.common.throwable.ThrowableFunction;
import org.jacpfx.common.throwable.ThrowableSupplier;
import org.jacpfx.vertx.event.interfaces.blocking.ExecuteEventbusStringCallBlocking;
import org.jacpfx.vertx.event.response.basic.ExecuteEventbusBasicString;
import org.jacpfx.vertx.event.response.blocking.ResponseBlockingExecution;

public class ExecuteEventbusString
extends ExecuteEventbusBasicString {
    protected final long delay;
    protected final ExecuteEventbusStringCallBlocking excecuteAsyncEventBusAndReply;
    protected final ThrowableSupplier<String> stringSupplier;
    protected final ThrowableFunction<Throwable, String> onFailureRespond;

    public ExecuteEventbusString(String methodId, Vertx vertx, Throwable failure, Consumer<Throwable> errorMethodHandler, Message<Object> message, ThrowableSupplier<String> stringSupplier, ExecuteEventbusStringCallBlocking excecuteAsyncEventBusAndReply, Consumer<Throwable> errorHandler, ThrowableFunction<Throwable, String> onFailureRespond, DeliveryOptions deliveryOptions, int retryCount, long timeout, long delay, long circuitBreakerTimeout) {
        super(methodId, vertx, failure, errorMethodHandler, message, null, null, errorHandler, null, deliveryOptions, retryCount, timeout, circuitBreakerTimeout);
        this.delay = delay;
        this.excecuteAsyncEventBusAndReply = excecuteAsyncEventBusAndReply;
        this.stringSupplier = stringSupplier;
        this.onFailureRespond = onFailureRespond;
    }

    @Override
    public void execute(DeliveryOptions deliveryOptions) {
        Objects.requireNonNull(deliveryOptions);
        new ExecuteEventbusString(this.methodId, this.vertx, this.failure, this.errorMethodHandler, (Message<Object>)this.message, this.stringSupplier, this.excecuteAsyncEventBusAndReply, this.errorHandler, this.onFailureRespond, deliveryOptions, this.retryCount, this.timeout, this.delay, this.circuitBreakerTimeout).execute();
    }

    @Override
    public void execute() {
        Optional.ofNullable(this.excecuteAsyncEventBusAndReply).ifPresent(evFunction -> {
            try {
                evFunction.execute(this.methodId, this.vertx, this.errorMethodHandler, (Message<Object>)this.message, this.errorHandler, this.onFailureRespond, this.deliveryOptions, this.retryCount, this.timeout, this.delay, this.circuitBreakerTimeout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Optional.ofNullable(this.stringSupplier).ifPresent(supplier -> {
            int retry = this.retryCount;
            this.vertx.executeBlocking(handler -> this.executeAsync((ThrowableSupplier<String>)supplier, retry, (Future<ExecutionResult<String>>)handler), false, this.getAsyncResultHandler(retry));
        });
    }

    private void executeAsync(ThrowableSupplier<String> supplier, int retry, Future<ExecutionResult<String>> blockingHandler) {
        ResponseBlockingExecution.createResponseBlocking(this.methodId, supplier, blockingHandler, this.errorHandler, this.onFailureRespond, this.errorMethodHandler, this.vertx, this.failure, retry, this.timeout, this.circuitBreakerTimeout, this.delay);
    }

    private Handler<AsyncResult<ExecutionResult<String>>> getAsyncResultHandler(int retry) {
        return value -> {
            if (!value.failed()) {
                ExecutionResult result = (ExecutionResult)value.result();
                this.respond((String)result.getResult());
            } else if (retry == 0) {
                this.fail(value.cause().getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        };
    }
}

